/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.impl.processor.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotatedTypeElement;

public class ClassElement
implements AnnotatedTypeElement {
    private final Class<?> delegate;
    private Annotation[] annotations;

    public ClassElement(Class<?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)Optional.ofNullable(this.delegate.getAnnotation(annotationClass)).orElseGet(() -> this.findInInterfaces(annotationClass));
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] annotationArray;
        if (this.annotations == null) {
            this.annotations = this.gatherAnnotations();
            annotationArray = this.annotations;
        } else {
            annotationArray = this.annotations;
        }
        return annotationArray;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    @Override
    public Type getType() {
        return this.delegate;
    }

    private Annotation[] gatherAnnotations() {
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(Arrays.asList(this.delegate.getAnnotations()));
        annotations.addAll(this.findInterfaces(this.delegate).flatMap(i -> Stream.of(i.getAnnotations()).filter(it -> !this.delegate.isAnnotationPresent(it.annotationType()))).distinct().collect(Collectors.toList()));
        return annotations.toArray(new Annotation[0]);
    }

    private <T extends Annotation> T findInInterfaces(Class<T> annotationClass) {
        return (T)((Annotation)this.findInterfaces(this.delegate).filter(it -> it.isAnnotationPresent(annotationClass)).findFirst().map(it -> it.getAnnotation(annotationClass)).orElse(null));
    }

    private Stream<Class<?>> findInterfaces(Class<?> delegate) {
        return Stream.of(delegate.getInterfaces());
    }
}

