/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.ietf.jgss.GSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticationHandler
implements AuthenticationHandler {
    private static Logger LOG = LoggerFactory.getLogger(KerberosAuthenticationHandler.class);
    public static final String TYPE = "kerberos";
    public static final String PRINCIPAL = "kerberos.principal";
    public static final String KEYTAB = "kerberos.keytab";
    public static final String NAME_RULES = "kerberos.name.rules";
    private String principal;
    private String keytab;
    private GSSManager gssManager;
    private LoginContext loginContext;

    public void init(Properties config) throws ServletException {
        try {
            this.principal = config.getProperty(PRINCIPAL, this.principal);
            if (this.principal == null || this.principal.trim().length() == 0) {
                throw new ServletException("Principal not defined in configuration");
            }
            this.keytab = config.getProperty(KEYTAB, this.keytab);
            if (this.keytab == null || this.keytab.trim().length() == 0) {
                throw new ServletException("Keytab not defined in configuration");
            }
            if (!new File(this.keytab).exists()) {
                throw new ServletException("Keytab does not exist: " + this.keytab);
            }
            String nameRules = config.getProperty(NAME_RULES, null);
            if (nameRules != null) {
                KerberosName.setRules((String)nameRules);
            }
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(this.principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            KerberosConfiguration kerberosConfiguration = new KerberosConfiguration(this.keytab, this.principal);
            LOG.info("Login using keytab " + this.keytab + ", for principal " + this.principal);
            this.loginContext = new LoginContext("", subject, null, (Configuration)kerberosConfiguration);
            this.loginContext.login();
            Subject serverSubject = this.loginContext.getSubject();
            try {
                this.gssManager = (GSSManager)Subject.doAs(serverSubject, new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
            LOG.info("Initialized, principal [{}] from keytab [{}]", (Object)this.principal, (Object)this.keytab);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void destroy() {
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
                this.loginContext = null;
            }
        }
        catch (LoginException ex) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getType() {
        return TYPE;
    }

    protected String getPrincipal() {
        return this.principal;
    }

    protected String getKeytab() {
        return this.keytab;
    }

    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Negotiate")) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.setStatus(401);
            if (authorization == null) {
                LOG.trace("SPNEGO starting");
            } else {
                LOG.warn("'Authorization' does not start with 'Negotiate' :  {}", (Object)authorization);
            }
        } else {
            authorization = authorization.substring("Negotiate".length()).trim();
            Base64 base64 = new Base64(0);
            byte[] clientToken = base64.decode(authorization);
            Subject serverSubject = this.loginContext.getSubject();
            try {
                token = (AuthenticationToken)Subject.doAs(serverSubject, new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw new AuthenticationException((Throwable)ex.getException());
            }
        }
        return token;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ GSSManager access$100(KerberosAuthenticationHandler x0) {
        return x0.gssManager;
    }
}

