/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Properties;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestKerberosAuthenticationHandler
extends TestCase {
    private KerberosAuthenticationHandler handler;

    protected void setUp() throws Exception {
        super.setUp();
        this.handler = new KerberosAuthenticationHandler();
        Properties props = new Properties();
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@" + KerberosTestUtils.getRealm() + ")s/@.*//\n");
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            this.handler = null;
            throw ex;
        }
    }

    protected void tearDown() throws Exception {
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
        super.tearDown();
    }

    public void testNameRules() throws Exception {
        KerberosName kn = new KerberosName(KerberosTestUtils.getServerPrincipal());
        TestKerberosAuthenticationHandler.assertEquals((String)KerberosTestUtils.getRealm(), (String)kn.getRealm());
        this.handler.destroy();
        KerberosName.setRules((String)"RULE:[1:$1@$0](.*@FOO)s/@.*//\nDEFAULT");
        this.handler = new KerberosAuthenticationHandler();
        Properties props = new Properties();
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@BAR)s/@.*//\nDEFAULT");
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            // empty catch block
        }
        kn = new KerberosName("bar@BAR");
        TestKerberosAuthenticationHandler.assertEquals((String)"bar", (String)kn.getShortName());
        kn = new KerberosName("bar@FOO");
        try {
            kn.getShortName();
            TestKerberosAuthenticationHandler.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testInit() throws Exception {
        TestKerberosAuthenticationHandler.assertEquals((String)KerberosTestUtils.getServerPrincipal(), (String)this.handler.getPrincipal());
        TestKerberosAuthenticationHandler.assertEquals((String)KerberosTestUtils.getKeytabFile(), (String)this.handler.getKeytab());
    }

    public void testType() throws Exception {
        KerberosAuthenticationHandler handler = new KerberosAuthenticationHandler();
        TestKerberosAuthenticationHandler.assertEquals((String)"kerberos", (String)handler.getType());
    }

    public void testRequestWithoutAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        TestKerberosAuthenticationHandler.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader("WWW-Authenticate", "Negotiate");
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    public void testRequestWithInvalidAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)"invalid");
        TestKerberosAuthenticationHandler.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader("WWW-Authenticate", "Negotiate");
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    public void testRequestWithIncompleteAuthorization() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)"Negotiate");
        try {
            this.handler.authenticate(request, response);
            TestKerberosAuthenticationHandler.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            TestKerberosAuthenticationHandler.fail();
        }
    }

    public void testRequestWithAuthorization() throws Exception {
        String token = (String)KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)("Negotiate " + token));
        AuthenticationToken authToken = this.handler.authenticate(request, response);
        if (authToken != null) {
            ((HttpServletResponse)Mockito.verify((Object)response)).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), Mockito.matches((String)"Negotiate .*"));
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
            TestKerberosAuthenticationHandler.assertEquals((String)KerberosTestUtils.getClientPrincipal(), (String)authToken.getName());
            TestKerberosAuthenticationHandler.assertTrue((boolean)KerberosTestUtils.getClientPrincipal().startsWith(authToken.getUserName()));
            TestKerberosAuthenticationHandler.assertEquals((String)"kerberos", (String)authToken.getType());
        } else {
            ((HttpServletResponse)Mockito.verify((Object)response)).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), Mockito.matches((String)"Negotiate .*"));
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
        }
    }

    public void testRequestWithInvalidKerberosAuthorization() throws Exception {
        String token = new Base64(0).encodeToString(new byte[]{0, 1, 2});
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("Authorization")).thenReturn((Object)("Negotiate" + token));
        try {
            this.handler.authenticate(request, response);
            TestKerberosAuthenticationHandler.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            TestKerberosAuthenticationHandler.fail();
        }
    }
}

