/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication;

import java.io.File;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.security.authentication.KerberosTestUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class KerberosTestUtils {
    private static final String PREFIX = "hadoop-auth.test.";
    public static final String REALM = "hadoop-auth.test.kerberos.realm";
    public static final String CLIENT_PRINCIPAL = "hadoop-auth.test.kerberos.client.principal";
    public static final String SERVER_PRINCIPAL = "hadoop-auth.test.kerberos.server.principal";
    public static final String KEYTAB_FILE = "hadoop-auth.test.kerberos.keytab.file";

    public static String getRealm() {
        return System.getProperty("hadoop-auth.test.kerberos.realm", "LOCALHOST");
    }

    public static String getClientPrincipal() {
        return System.getProperty("hadoop-auth.test.kerberos.client.principal", "client") + "@" + KerberosTestUtils.getRealm();
    }

    public static String getServerPrincipal() {
        return System.getProperty("hadoop-auth.test.kerberos.server.principal", "HTTP/localhost") + "@" + KerberosTestUtils.getRealm();
    }

    public static String getKeytabFile() {
        String keytabFile = new File(System.getProperty("user.home"), System.getProperty("user.name") + ".keytab").toString();
        return System.getProperty("hadoop-auth.test.kerberos.keytab.file", keytabFile);
    }

    public static <T> T doAs(String principal, Callable<T> callable) throws Exception {
        LoginContext loginContext = null;
        try {
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(KerberosTestUtils.getClientPrincipal()));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, (Configuration)new KerberosConfiguration(principal));
            loginContext.login();
            subject = loginContext.getSubject();
            Object t = Subject.doAs(subject, new /* Unavailable Anonymous Inner Class!! */);
            return t;
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }

    public static <T> T doAsClient(Callable<T> callable) throws Exception {
        return (T)KerberosTestUtils.doAs((String)KerberosTestUtils.getClientPrincipal(), callable);
    }

    public static <T> T doAsServer(Callable<T> callable) throws Exception {
        return (T)KerberosTestUtils.doAs((String)KerberosTestUtils.getServerPrincipal(), callable);
    }
}

