/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;

public class PseudoAuthenticationHandler
implements AuthenticationHandler {
    public static final String TYPE = "simple";
    public static final String ANONYMOUS_ALLOWED = "simple.anonymous.allowed";
    private boolean acceptAnonymous;

    public void init(Properties config) throws ServletException {
        this.acceptAnonymous = Boolean.parseBoolean(config.getProperty(ANONYMOUS_ALLOWED, "false"));
    }

    protected boolean getAcceptAnonymous() {
        return this.acceptAnonymous;
    }

    public void destroy() {
    }

    public String getType() {
        return TYPE;
    }

    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        String userName = request.getParameter("user.name");
        if (userName != null) return new AuthenticationToken(userName, userName, this.getType());
        if (!this.getAcceptAnonymous()) throw new AuthenticationException("Anonymous requests are disallowed");
        return AuthenticationToken.ANONYMOUS;
    }
}

