/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.TestKerberosAuthenticationHandler;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAltKerberosAuthenticationHandler
extends TestKerberosAuthenticationHandler {
    protected KerberosAuthenticationHandler getNewAuthenticationHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected String getExpectedType() {
        return "alt-kerberos";
    }

    public void testAlternateAuthenticationAsBrowser() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader("User-Agent")).thenReturn((Object)"Some Browser");
        AuthenticationToken token = this.handler.authenticate(request, response);
        TestAltKerberosAuthenticationHandler.assertEquals((String)"A", (String)token.getUserName());
        TestAltKerberosAuthenticationHandler.assertEquals((String)"B", (String)token.getName());
        TestAltKerberosAuthenticationHandler.assertEquals((String)this.getExpectedType(), (String)token.getType());
    }

    public void testNonDefaultNonBrowserUserAgentAsBrowser() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
        this.handler = this.getNewAuthenticationHandler();
        Properties props = this.getDefaultProperties();
        props.setProperty("alt-kerberos.non-browser.user-agents", "foo, bar");
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            this.handler = null;
            throw ex;
        }
        Mockito.when((Object)request.getHeader("User-Agent")).thenReturn((Object)"blah");
        AuthenticationToken token = this.handler.authenticate(request, response);
        TestAltKerberosAuthenticationHandler.assertEquals((String)"A", (String)token.getUserName());
        TestAltKerberosAuthenticationHandler.assertEquals((String)"B", (String)token.getName());
        TestAltKerberosAuthenticationHandler.assertEquals((String)this.getExpectedType(), (String)token.getType());
    }

    public void testNonDefaultNonBrowserUserAgentAsNonBrowser() throws Exception {
        if (this.handler != null) {
            this.handler.destroy();
            this.handler = null;
        }
        this.handler = this.getNewAuthenticationHandler();
        Properties props = this.getDefaultProperties();
        props.setProperty("alt-kerberos.non-browser.user-agents", "foo, bar");
        try {
            this.handler.init(props);
        }
        catch (Exception ex) {
            this.handler = null;
            throw ex;
        }
        this.testRequestWithoutAuthorization();
        this.testRequestWithInvalidAuthorization();
        this.testRequestWithAuthorization();
        this.testRequestWithInvalidKerberosAuthorization();
    }
}

