/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestKerberosUtil {
    static String testKeytab = "test.keytab";
    static String[] testPrincipals = new String[]{"HTTP@testRealm", "test/testhost@testRealm", "HTTP/testhost@testRealm", "HTTP1/testhost@testRealm", "HTTP/testhostanother@testRealm"};

    @After
    public void deleteKeytab() {
        File keytabFile = new File(testKeytab);
        if (keytabFile.exists()) {
            keytabFile.delete();
        }
    }

    @Test
    public void testGetServerPrincipal() throws IOException, UnknownHostException {
        String service = "TestKerberosUtil";
        String localHostname = KerberosUtil.getLocalHostName();
        String testHost = "FooBar";
        String defaultRealm = KerberosUtil.getDefaultRealmProtected();
        String atDefaultRealm = defaultRealm == null || defaultRealm.equals("") ? "" : "@" + defaultRealm;
        Assert.assertEquals((String)"testGetServerPrincipal assumes localhost realm is default", (Object)KerberosUtil.getDomainRealm((String)(service + "/" + localHostname.toLowerCase(Locale.ENGLISH))), (Object)defaultRealm);
        Assert.assertEquals((String)"testGetServerPrincipal assumes realm of testHost 'FooBar' is default", (Object)KerberosUtil.getDomainRealm((String)(service + "/" + testHost.toLowerCase(Locale.ENGLISH))), (Object)defaultRealm);
        Assert.assertEquals((String)"When no hostname is sent", (Object)(service + "/" + localHostname.toLowerCase(Locale.ENGLISH) + atDefaultRealm), (Object)KerberosUtil.getServicePrincipal((String)service, null));
        Assert.assertEquals((String)"When empty hostname is sent", (Object)(service + "/" + localHostname.toLowerCase(Locale.ENGLISH) + atDefaultRealm), (Object)KerberosUtil.getServicePrincipal((String)service, (String)""));
        Assert.assertEquals((String)"When 0.0.0.0 hostname is sent", (Object)(service + "/" + localHostname.toLowerCase(Locale.ENGLISH) + atDefaultRealm), (Object)KerberosUtil.getServicePrincipal((String)service, (String)"0.0.0.0"));
        Assert.assertEquals((String)"When uppercase hostname is sent", (Object)(service + "/" + testHost.toLowerCase(Locale.ENGLISH) + atDefaultRealm), (Object)KerberosUtil.getServicePrincipal((String)service, (String)testHost));
        Assert.assertEquals((String)"When lowercase hostname is sent", (Object)(service + "/" + testHost.toLowerCase(Locale.ENGLISH) + atDefaultRealm), (Object)KerberosUtil.getServicePrincipal((String)service, (String)testHost.toLowerCase(Locale.ENGLISH)));
    }

    @Test
    public void testGetPrincipalNamesMissingKeytab() {
        try {
            KerberosUtil.getPrincipalNames((String)testKeytab);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPrincipalNamesMissingPattern() throws IOException {
        this.createKeyTab(testKeytab, new String[]{"test/testhost@testRealm"});
        try {
            KerberosUtil.getPrincipalNames((String)testKeytab, null);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetPrincipalNamesFromKeytab() throws IOException {
        this.createKeyTab(testKeytab, testPrincipals);
        String[] principals = KerberosUtil.getPrincipalNames((String)testKeytab);
        Assert.assertNotNull((String)"principals cannot be null", (Object)principals);
        int expectedSize = 0;
        List<String> principalList = Arrays.asList(principals);
        for (String principal : testPrincipals) {
            Assert.assertTrue((String)("missing principal " + principal), (boolean)principalList.contains(principal));
            ++expectedSize;
        }
        Assert.assertEquals((long)expectedSize, (long)principals.length);
    }

    @Test
    public void testGetPrincipalNamesFromKeytabWithPattern() throws IOException {
        this.createKeyTab(testKeytab, testPrincipals);
        Pattern httpPattern = Pattern.compile("HTTP/.*");
        String[] httpPrincipals = KerberosUtil.getPrincipalNames((String)testKeytab, (Pattern)httpPattern);
        Assert.assertNotNull((String)"principals cannot be null", (Object)httpPrincipals);
        int expectedSize = 0;
        List<String> httpPrincipalList = Arrays.asList(httpPrincipals);
        for (String principal : testPrincipals) {
            if (!httpPattern.matcher(principal).matches()) continue;
            Assert.assertTrue((String)("missing principal " + principal), (boolean)httpPrincipalList.contains(principal));
            ++expectedSize;
        }
        Assert.assertEquals((long)expectedSize, (long)httpPrincipals.length);
    }

    private void createKeyTab(String fileName, String[] principalNames) throws IOException {
        ArrayList<KeytabEntry> lstEntries = new ArrayList<KeytabEntry>();
        for (String principal : principalNames) {
            for (int kvno = 1; kvno <= 3; ++kvno) {
                EncryptionKey key = new EncryptionKey(EncryptionType.UNKNOWN, "samplekey1".getBytes(), kvno);
                KeytabEntry keytabEntry = new KeytabEntry(principal, 1L, new KerberosTime(), 1, key);
                lstEntries.add(keytabEntry);
            }
        }
        Keytab keytab = Keytab.getInstance();
        keytab.setEntries(lstEntries);
        keytab.write(new File(testKeytab));
    }

    @Test
    public void testServicePrincipalDecode() throws Exception {
        String krb5Default = "YIIB2AYJKoZIhvcSAQICAQBuggHHMIIBw6ADAgEFoQMCAQ6iBwMFACAAAACjgethgegwgeWgAwIBBaENGwtFWEFNUExFLkNPTaIcMBqgAwIBAKETMBEbBEhUVFAbCWxvY2FsaG9zdKOBsDCBraADAgERoQMCAQGigaAEgZ23QsT1+16T23niJI1uFRU0FN13hhPSLAl4+oAqpV5s1Z6E+G2VKGx2+rUF21utOdlwUK/J5CKFHxM4zfNsmzRFhdk5moJW6AWHuRqGJ9hrZgTxA2vOBIn/tju+n/vJVEcUvW0fDiPfjPIPFOlc7V9GlWvZFyr5NMJSFwspKJXYh/FSNpSVTecfGskjded9TZzR2tOVzgpjFvAu/DETpIG/MIG8oAMCARGigbQEgbGWnbKlV1oo7/gzT4hi/Q41ff2luDnSxADEmo6M8LC42scsYMLNgU4iLJhuf4YLb7ueh790HrbB6Kdes71/gSBiLI2/mn3BqNE43gt94dQ8VFBix4nJCsYnuORYxLJjRSJE+3ImJNsSjqafGRI0sp9w3hc4IVm8afb3Ggm6PgRIyyGNdTzK/p03v+zA01MJh3htuOgLKUOVz002pHnGzu/purZ5mOyaQT12vHxJ2T+Cwi8=";
        String krb5Other = "YIIB2AYJKoZIhvcSAQICAQBuggHHMIIBw6ADAgEFoQMCAQ6iBwMFACAAAACjgethgegwgeWgAwIBBaENGwtBQkNERUZHLk9SR6IcMBqgAwIBAKETMBEbBEhUVFAbCW90aGVyaG9zdKOBsDCBraADAgERoQMCAQGigaAEgZ23QsT1+16T23niJI1uFRU0FN13hhPSLAl4+oAqpV5s1Z6E+G2VKGx2+rUF21utOdlwUK/J5CKFHxM4zfNsmzRFhdk5moJW6AWHuRqGJ9hrZgTxA2vOBIn/tju+n/vJVEcUvW0fDiPfjPIPFOlc7V9GlWvZFyr5NMJSFwspKJXYh/FSNpSVTecfGskjded9TZzR2tOVzgpjFvAu/DETpIG/MIG8oAMCARGigbQEgbGWnbKlV1oo7/gzT4hi/Q41ff2luDnSxADEmo6M8LC42scsYMLNgU4iLJhuf4YLb7ueh790HrbB6Kdes71/gSBiLI2/mn3BqNE43gt94dQ8VFBix4nJCsYnuORYxLJjRSJE+3ImJNsSjqafGRI0sp9w3hc4IVm8afb3Ggm6PgRIyyGNdTzK/p03v+zA01MJh3htuOgLKUOVz002pHnGzu/purZ5mOyaQT12vHxJ2T+Cwi8K";
        String spnegoDefault = "YIICCQYGKwYBBQUCoIIB/TCCAfmgDTALBgkqhkiG9xIBAgKhBAMCAXaiggHgBIIB3GCCAdgGCSqGSIb3EgECAgEAboIBxzCCAcOgAwIBBaEDAgEOogcDBQAgAAAAo4HrYYHoMIHloAMCAQWhDRsLRVhBTVBMRS5DT02iHDAaoAMCAQChEzARGwRIVFRQGwlsb2NhbGhvc3SjgbAwga2gAwIBEaEDAgEBooGgBIGdBWbzvV1RIqb7WuPIW3RTkFtwjU9P/oFAbujGPd8h/qkCszroNdvHhUkPntuOqhFBntMobilgTqNEdDUGvBbfkJaRklNGqT/IAOUV6tlGpBUCXquR5UdPzPpUvGZiVRUuFGH5DGGHvYF1CwXPp2l1Jq373vSLQ1kBl6TXl+aKLsZYhVUjKvE7Auippclbhv/GGGex/TcjNH48k47OQaSBvzCBvKADAgERooG0BIGxeChp3TMVtWbCdFGoYL+35r2762j+OEwZRfcj4xCK7j0mUTcxLtyVGxyY9Ax+ljl5gTwzRhXcJq0TTjiQwKJckeZ837mXQAURbfJpFc3VLAXGfNkMFCR7ZkWpGA1Vzc3PeUNczn2DLpu8sme55HFFQDi/0akW6Lwv/iCrpwIkZPyZPjaEmwLVALu4E8m0Ka3fJkPVGAhamg9OQpuREIK0pCk3ZSHhJz8qMwduzRZHc4vN";
        String spnegoOther = "YIICCQYGKwYBBQUCoIIB/TCCAfmgDTALBgkqhkiG9xIBAgKhBAMCAXaiggHgBIIB3GCCAdgGCSqGSIb3EgECAgEAboIBxzCCAcOgAwIBBaEDAgEOogcDBQAgAAAAo4HrYYHoMIHloAMCAQWhDRsLQUJDREVGRy5PUkeiHDAaoAMCAQChEzARGwRIVFRQGwlvdGhlcmhvc3SjgbAwga2gAwIBEaEDAgEBooGgBIGdBWbzvV1RIqb7WuPIW3RTkFtwjU9P/oFAbujGPd8h/qkCszroNdvHhUkPntuOqhFBntMobilgTqNEdDUGvBbfkJaRklNGqT/IAOUV6tlGpBUCXquR5UdPzPpUvGZiVRUuFGH5DGGHvYF1CwXPp2l1Jq373vSLQ1kBl6TXl+aKLsZYhVUjKvE7Auippclbhv/GGGex/TcjNH48k47OQaSBvzCBvKADAgERooG0BIGxeChp3TMVtWbCdFGoYL+35r2762j+OEwZRfcj4xCK7j0mUTcxLtyVGxyY9Ax+ljl5gTwzRhXcJq0TTjiQwKJckeZ837mXQAURbfJpFc3VLAXGfNkMFCR7ZkWpGA1Vzc3PeUNczn2DLpu8sme55HFFQDi/0akW6Lwv/iCrpwIkZPyZPjaEmwLVALu4E8m0Ka3fJkPVGAhamg9OQpuREIK0pCk3ZSHhJz8qMwduzRZHc4vNCg==";
        Assert.assertEquals((Object)"HTTP/localhost@EXAMPLE.COM", (Object)TestKerberosUtil.getPrincipal(krb5Default));
        Assert.assertEquals((Object)"HTTP/otherhost@ABCDEFG.ORG", (Object)TestKerberosUtil.getPrincipal(krb5Other));
        Assert.assertEquals((Object)"HTTP/localhost@EXAMPLE.COM", (Object)TestKerberosUtil.getPrincipal(spnegoDefault));
        Assert.assertEquals((Object)"HTTP/otherhost@ABCDEFG.ORG", (Object)TestKerberosUtil.getPrincipal(spnegoOther));
    }

    private static String getPrincipal(String token) {
        return KerberosUtil.getTokenServerName((byte[])Base64.decodeBase64((String)token));
    }
}

