/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.common;

import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okio.Buffer;
import org.apache.hadoop.fs.adl.TestADLResponseData;
import org.apache.hadoop.fs.adl.common.ExpectedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataForRead {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataForRead.class);
    private byte[] actualData;
    private ArrayList<ExpectedResponse> responses;
    private Dispatcher dispatcher;
    private int intensityOfTest;
    private boolean checkOfNoOfCalls;
    private int expectedNoNetworkCall;

    public TestDataForRead(final byte[] actualData, int expectedNoNetworkCall, int intensityOfTest, boolean checkOfNoOfCalls) {
        this.checkOfNoOfCalls = checkOfNoOfCalls;
        this.actualData = actualData;
        this.responses = new ArrayList();
        this.expectedNoNetworkCall = expectedNoNetworkCall;
        this.intensityOfTest = intensityOfTest;
        this.dispatcher = new Dispatcher(){

            public MockResponse dispatch(RecordedRequest recordedRequest) throws InterruptedException {
                if (recordedRequest.getRequestLine().contains("op=GETFILESTATUS")) {
                    return new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getGetFileStatusJSONResponse(actualData.length));
                }
                if (recordedRequest.getRequestLine().contains("op=OPEN")) {
                    String request = recordedRequest.getRequestLine();
                    int offset = 0;
                    int byteCount = 0;
                    Pattern pattern = Pattern.compile("offset=([0-9]+)");
                    Matcher matcher = pattern.matcher(request);
                    if (matcher.find()) {
                        LOG.debug(matcher.group(1));
                        offset = Integer.parseInt(matcher.group(1));
                    }
                    if ((matcher = (pattern = Pattern.compile("length=([0-9]+)")).matcher(request)).find()) {
                        LOG.debug(matcher.group(1));
                        byteCount = Integer.parseInt(matcher.group(1));
                    }
                    Buffer buf = new Buffer();
                    buf.write(actualData, offset, Math.min(actualData.length - offset, byteCount));
                    return new MockResponse().setResponseCode(200).setChunkedBody(buf, 0x400000);
                }
                return new MockResponse().setBody("NOT SUPPORTED").setResponseCode(501);
            }
        };
    }

    public boolean isCheckOfNoOfCalls() {
        return this.checkOfNoOfCalls;
    }

    public int getExpectedNoNetworkCall() {
        return this.expectedNoNetworkCall;
    }

    public int getIntensityOfTest() {
        return this.intensityOfTest;
    }

    public byte[] getActualData() {
        return this.actualData;
    }

    public ArrayList<ExpectedResponse> getResponses() {
        return this.responses;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }
}

