/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestMetadata {
    private FileSystem adlStore;
    private Path parent = new Path("test");

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
        this.adlStore = AdlStorageConfiguration.createStorageConnector();
    }

    @After
    public void cleanUp() throws Exception {
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            this.adlStore.delete(this.parent, true);
        }
    }

    @Test
    public void testContentSummaryOnFile() throws IOException {
        Path child = new Path(UUID.randomUUID().toString());
        Path testFile = new Path(this.parent, child);
        FSDataOutputStream out = this.adlStore.create(testFile);
        for (int i = 0; i < 1024; ++i) {
            out.write(97);
        }
        out.close();
        Assert.assertTrue((boolean)this.adlStore.isFile(testFile));
        ContentSummary summary = this.adlStore.getContentSummary(testFile);
        Assert.assertEquals((long)1024L, (long)summary.getSpaceConsumed());
        Assert.assertEquals((long)1L, (long)summary.getFileCount());
        Assert.assertEquals((long)0L, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)1024L, (long)summary.getLength());
    }

    @Test
    public void testContentSummaryOnFolder() throws IOException {
        Path child = new Path(UUID.randomUUID().toString());
        Path testFile = new Path(this.parent, child);
        FSDataOutputStream out = this.adlStore.create(testFile);
        for (int i = 0; i < 1024; ++i) {
            out.write(97);
        }
        out.close();
        Assert.assertTrue((boolean)this.adlStore.isFile(testFile));
        ContentSummary summary = this.adlStore.getContentSummary(this.parent);
        Assert.assertEquals((long)1024L, (long)summary.getSpaceConsumed());
        Assert.assertEquals((long)1L, (long)summary.getFileCount());
        Assert.assertEquals((long)1L, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)1024L, (long)summary.getLength());
    }

    @Test
    public void listStatusOnFile() throws IOException {
        Path path = new Path(this.parent, "a.txt");
        FileSystem fs = this.adlStore;
        fs.createNewFile(path);
        Assert.assertTrue((boolean)fs.isFile(path));
        FileStatus[] statuses = fs.listStatus(path);
        Assert.assertEquals((Object)path.makeQualified(fs.getUri(), fs.getWorkingDirectory()), (Object)statuses[0].getPath());
    }

    @Test
    public void testUserRepresentationConfiguration() throws IOException {
        Path path = new Path(this.parent, "a.txt");
        AdlFileSystem fs = (AdlFileSystem)this.adlStore;
        fs.setUserGroupRepresentationAsUPN(false);
        fs.createNewFile(path);
        Assert.assertTrue((boolean)fs.isFile(path));
        FileStatus fileStatus = fs.getFileStatus(path);
        UUID.fromString(fileStatus.getGroup());
        UUID.fromString(fileStatus.getOwner());
        fs.setUserGroupRepresentationAsUPN(true);
        fileStatus = fs.getFileStatus(path);
        try {
            UUID.fromString(fileStatus.getGroup());
            UUID.fromString(fileStatus.getOwner());
            Assert.fail((String)"Expected user friendly name to be non guid value.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

