/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlMockWebServer;
import org.apache.hadoop.fs.adl.TestADLResponseData;
import org.apache.hadoop.fs.adl.common.Parallelized;
import org.apache.hadoop.fs.adl.common.TestDataForRead;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parallelized.class)
public class TestAdlRead
extends AdlMockWebServer {
    private TestDataForRead testData;

    public TestAdlRead(TestDataForRead testData) {
        Configuration configuration = new Configuration();
        configuration.setInt("adl.feature.client.cache.readahead", 4096);
        this.setConf(configuration);
        this.testData = testData;
    }

    @Parameterized.Parameters(name="{index}")
    public static Collection testDataForReadOperation() {
        return Arrays.asList({new TestDataForRead("Hello World".getBytes(), 2, 1000, true)}, {new TestDataForRead("the problem you appear to be wrestling with is that this doesn't display very well. ".getBytes(), 2, 1000, true)}, {new TestDataForRead("\u60a8\u7684\u6578\u64da\u662f\u5bf6\u8cb4\u7684\u8cc7\u7522\uff0c\u4ee5\u60a8\u7684\u7d44\u7e54\uff0c\u4e26\u6709\u7576\u524d\u548c\u672a\u4f86\u50f9\u503c\u3002\u7531\u65bc\u9019\u500b\u539f\u56e0\uff0c\u6240\u6709\u7684\u6578\u64da\u61c9\u5b58\u5132\u4ee5\u4f9b\u5c07\u4f86\u5206\u6790\u3002\u4eca\u5929\uff0c\u9019\u5f80\u5f80\u662f\u4e0d\u9019\u6a23\u505a\uff0c\u56e0\u70ba\u50b3\u7d71\u7684\u5206\u6790\u57fa\u790e\u67b6\u69cb\u7684\u9650\u5236\uff0c\u50cf\u6a21\u5f0f\u7684\u9810\u5b9a\u7fa9\uff0c\u5b58\u5132\u5927\u6578\u64da\u96c6\u548c\u4e0d\u540c\u7684\u6578\u64da\u7b52\u5009\u7684\u50b3\u64ad\u7684\u6210\u672c\u3002\u70ba\u4e86\u61c9\u5c0d\u9019\u4e00\u6311\u6230\uff0c\u6578\u64da\u6e56\u9762\u6982\u5ff5\u88ab\u5f15\u5165\u4f5c\u70ba\u4e00\u500b\u4f01\u696d\u7d1a\u5b58\u5132\u5eab\u4f86\u5b58\u5132\u6240\u6709\u985e\u578b\u7684\u5728\u4e00\u500b\u5730\u65b9\u6536\u96c6\u5230\u7684\u6578\u64da\u3002\u5c0d\u65bc\u904b\u4f5c\u548c\u63a2\u7d22\u6027\u5206\u6790\u7684\u76ee\u7684\uff0c\u6240\u6709\u985e\u578b\u7684\u6578\u64da\u53ef\u4ee5\u5b9a\u7fa9\u9700\u6c42\u6216\u6a21\u5f0f\u4e4b\u524d\u88ab\u5b58\u5132\u5728\u6578\u64da\u6e56\u3002".getBytes(), 2, 1000, true)}, {new TestDataForRead(TestADLResponseData.getRandomByteArrayData(4096), 2, 10, true)}, {new TestDataForRead(TestADLResponseData.getRandomByteArrayData(100), 2, 1000, true)}, {new TestDataForRead(TestADLResponseData.getRandomByteArrayData(1024), 2, 50, true)}, {new TestDataForRead(TestADLResponseData.getRandomByteArrayData(8192), 3, 10, false)}, {new TestDataForRead(TestADLResponseData.getRandomByteArrayData(16384), 5, 10, false)}, {new TestDataForRead(TestADLResponseData.getRandomByteArrayData(32768), 9, 10, false)}, {new TestDataForRead(TestADLResponseData.getRandomByteArrayData(65536), 17, 10, false)});
    }

    @Test
    public void testEntireBytes() throws IOException, InterruptedException {
        int count;
        this.getMockServer().setDispatcher(this.testData.getDispatcher());
        FSDataInputStream in = this.getMockAdlFileSystem().open(new Path("/test"));
        byte[] expectedData = new byte[this.testData.getActualData().length];
        int len = expectedData.length;
        int off = 0;
        for (int n = 0; n < len; n += count) {
            count = in.read(expectedData, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        Assert.assertEquals((long)expectedData.length, (long)this.testData.getActualData().length);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])this.testData.getActualData());
        in.close();
        if (this.testData.isCheckOfNoOfCalls()) {
            Assert.assertEquals((long)this.testData.getExpectedNoNetworkCall(), (long)this.getMockServer().getRequestCount());
        }
    }

    @Test
    public void testSeekOperation() throws IOException, InterruptedException {
        this.getMockServer().setDispatcher(this.testData.getDispatcher());
        FSDataInputStream in = this.getMockAdlFileSystem().open(new Path("/test"));
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            int position = random.nextInt(this.testData.getActualData().length);
            in.seek((long)position);
            Assert.assertEquals((long)position, (long)in.getPos());
            Assert.assertEquals((long)(this.testData.getActualData()[position] & 0xFF), (long)in.read());
        }
        in.close();
        if (this.testData.isCheckOfNoOfCalls()) {
            Assert.assertEquals((long)this.testData.getExpectedNoNetworkCall(), (long)this.getMockServer().getRequestCount());
        }
    }

    @Test
    public void testReadServerCalls() throws IOException, InterruptedException {
        this.getMockServer().setDispatcher(this.testData.getDispatcher());
        FSDataInputStream in = this.getMockAdlFileSystem().open(new Path("/test"));
        byte[] expectedData = new byte[this.testData.getActualData().length];
        in.readFully(expectedData);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])this.testData.getActualData());
        Assert.assertEquals((long)this.testData.getExpectedNoNetworkCall(), (long)this.getMockServer().getRequestCount());
        in.close();
    }

    @Test
    public void testReadFully() throws IOException, InterruptedException {
        this.getMockServer().setDispatcher(this.testData.getDispatcher());
        FSDataInputStream in = this.getMockAdlFileSystem().open(new Path("/test"));
        byte[] expectedData = new byte[this.testData.getActualData().length];
        in.readFully(expectedData);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])this.testData.getActualData());
        in.readFully(0L, expectedData);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])this.testData.getActualData());
        in.readFully(0L, expectedData, 0, expectedData.length);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])this.testData.getActualData());
        in.close();
    }

    @Test
    public void testRandomPositionalReadUsingReadFully() throws IOException, InterruptedException {
        byte[] actualDataSubset;
        byte[] expectedData;
        int length;
        int offset;
        int i;
        this.getMockServer().setDispatcher(this.testData.getDispatcher());
        FSDataInputStream in = this.getMockAdlFileSystem().open(new Path("/test"));
        ByteArrayInputStream actualData = new ByteArrayInputStream(this.testData.getActualData());
        Random random = new Random();
        for (i = 0; i < this.testData.getIntensityOfTest(); ++i) {
            offset = random.nextInt(this.testData.getActualData().length);
            length = this.testData.getActualData().length - offset;
            expectedData = new byte[length];
            actualDataSubset = new byte[length];
            actualData.reset();
            actualData.skip(offset);
            actualData.read(actualDataSubset, 0, length);
            in.readFully((long)offset, expectedData, 0, length);
            Assert.assertArrayEquals((byte[])expectedData, (byte[])actualDataSubset);
        }
        for (i = 0; i < this.testData.getIntensityOfTest(); ++i) {
            offset = random.nextInt(this.testData.getActualData().length);
            length = random.nextInt(this.testData.getActualData().length - offset);
            expectedData = new byte[length];
            actualDataSubset = new byte[length];
            actualData.reset();
            actualData.skip(offset);
            actualData.read(actualDataSubset, 0, length);
            in.readFully((long)offset, expectedData, 0, length);
            Assert.assertArrayEquals((byte[])expectedData, (byte[])actualDataSubset);
        }
        in.close();
    }
}

