/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.ClientCredsTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.DeviceCodeTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.MsiTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.RefreshTokenBasedTokenProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.fs.adl.SdkTokenProviderAdapter;
import org.apache.hadoop.fs.adl.TokenProviderType;
import org.apache.hadoop.fs.adl.common.CustomMockTokenProvider;
import org.apache.hadoop.fs.adl.oauth2.AzureADTokenProvider;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAzureADTokenProvider {
    private static final String CLIENT_ID = "MY_CLIENT_ID";
    private static final String REFRESH_TOKEN = "MY_REFRESH_TOKEN";
    private static final String CLIENT_SECRET = "MY_CLIENT_SECRET";
    private static final String REFRESH_URL = "http://localhost:8080/refresh";
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();

    @Test
    public void testRefreshTokenProvider() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        conf.set("fs.adl.oauth2.client.id", "MY_CLIENTID");
        conf.set("fs.adl.oauth2.refresh.token", "XYZ");
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.RefreshToken);
        conf.set("fs.adl.oauth2.refresh.url", REFRESH_URL);
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        fileSystem.initialize(uri, conf);
        AccessTokenProvider tokenProvider = fileSystem.getTokenProvider();
        Assert.assertTrue((boolean)(tokenProvider instanceof RefreshTokenBasedTokenProvider));
    }

    @Test
    public void testClientCredTokenProvider() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        conf.set("fs.adl.oauth2.client.id", "MY_CLIENTID");
        conf.set("fs.adl.oauth2.credential", "XYZ");
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.ClientCredential);
        conf.set("fs.adl.oauth2.refresh.url", REFRESH_URL);
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        fileSystem.initialize(uri, conf);
        AccessTokenProvider tokenProvider = fileSystem.getTokenProvider();
        Assert.assertTrue((boolean)(tokenProvider instanceof ClientCredsTokenProvider));
    }

    @Test
    public void testMSITokenProvider() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.MSI);
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        fileSystem.initialize(uri, conf);
        AccessTokenProvider tokenProvider = fileSystem.getTokenProvider();
        Assert.assertTrue((boolean)(tokenProvider instanceof MsiTokenProvider));
    }

    @Test
    public void testDeviceCodeTokenProvider() throws IOException, URISyntaxException {
        boolean runTest = false;
        if (runTest) {
            Configuration conf = new Configuration();
            conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.DeviceCode);
            conf.set("fs.adl.oauth2.devicecode.clientapp.id", "CLIENT_APP_ID_GUID");
            URI uri = new URI("adl://localhost:8080");
            AdlFileSystem fileSystem = new AdlFileSystem();
            fileSystem.initialize(uri, conf);
            AccessTokenProvider tokenProvider = fileSystem.getTokenProvider();
            Assert.assertTrue((boolean)(tokenProvider instanceof DeviceCodeTokenProvider));
        }
    }

    @Test
    public void testCustomCredTokenProvider() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.Custom);
        conf.setClass("fs.adl.oauth2.access.token.provider", CustomMockTokenProvider.class, AzureADTokenProvider.class);
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        fileSystem.initialize(uri, conf);
        AccessTokenProvider tokenProvider = fileSystem.getTokenProvider();
        Assert.assertTrue((boolean)(tokenProvider instanceof SdkTokenProviderAdapter));
    }

    @Test
    public void testInvalidProviderConfigurationForType() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.Custom);
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        try {
            fileSystem.initialize(uri, conf);
            Assert.fail((String)"Initialization should have failed due no token provider configuration");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"fs.adl.oauth2.access.token.provider", (Throwable)e);
        }
        conf.setClass("fs.adl.oauth2.access.token.provider", CustomMockTokenProvider.class, AzureADTokenProvider.class);
        fileSystem.initialize(uri, conf);
    }

    @Test
    public void testInvalidProviderConfigurationForClassPath() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.Custom);
        conf.set("fs.adl.oauth2.access.token.provider", "wrong.classpath.CustomMockTokenProvider");
        try {
            fileSystem.initialize(uri, conf);
            Assert.fail((String)"Initialization should have failed due invalid provider configuration");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("wrong.classpath.CustomMockTokenProvider"));
        }
    }

    private CredentialProvider createTempCredProvider(Configuration conf) throws URISyntaxException, IOException {
        File file = this.tempDir.newFile("test.jks");
        URI jks = ProviderUtils.nestURIForLocalJavaKeyStoreProvider((URI)file.toURI());
        conf.set("hadoop.security.credential.provider.path", jks.toString());
        return (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
    }

    @Test
    public void testRefreshTokenWithCredentialProvider() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        conf.set("fs.adl.oauth2.client.id", "DUMMY");
        conf.set("fs.adl.oauth2.refresh.token", "DUMMY");
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.RefreshToken);
        CredentialProvider provider = this.createTempCredProvider(conf);
        provider.createCredentialEntry("fs.adl.oauth2.client.id", CLIENT_ID.toCharArray());
        provider.createCredentialEntry("fs.adl.oauth2.refresh.token", REFRESH_TOKEN.toCharArray());
        provider.flush();
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        fileSystem.initialize(uri, conf);
        RefreshTokenBasedTokenProvider expected = new RefreshTokenBasedTokenProvider(CLIENT_ID, REFRESH_TOKEN);
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)expected, (Object)fileSystem.getTokenProvider()));
    }

    @Test
    public void testRefreshTokenWithCredentialProviderFallback() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        conf.set("fs.adl.oauth2.client.id", CLIENT_ID);
        conf.set("fs.adl.oauth2.refresh.token", REFRESH_TOKEN);
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.RefreshToken);
        this.createTempCredProvider(conf);
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        fileSystem.initialize(uri, conf);
        RefreshTokenBasedTokenProvider expected = new RefreshTokenBasedTokenProvider(CLIENT_ID, REFRESH_TOKEN);
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)expected, (Object)fileSystem.getTokenProvider()));
    }

    @Test
    public void testClientCredWithCredentialProvider() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        conf.set("fs.adl.oauth2.client.id", "DUMMY");
        conf.set("fs.adl.oauth2.credential", "DUMMY");
        conf.set("fs.adl.oauth2.refresh.url", "DUMMY");
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.ClientCredential);
        CredentialProvider provider = this.createTempCredProvider(conf);
        provider.createCredentialEntry("fs.adl.oauth2.client.id", CLIENT_ID.toCharArray());
        provider.createCredentialEntry("fs.adl.oauth2.credential", CLIENT_SECRET.toCharArray());
        provider.createCredentialEntry("fs.adl.oauth2.refresh.url", REFRESH_URL.toCharArray());
        provider.flush();
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        fileSystem.initialize(uri, conf);
        ClientCredsTokenProvider expected = new ClientCredsTokenProvider(REFRESH_URL, CLIENT_ID, CLIENT_SECRET);
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)expected, (Object)fileSystem.getTokenProvider()));
    }

    @Test
    public void testClientCredWithCredentialProviderFallback() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        conf.set("fs.adl.oauth2.client.id", CLIENT_ID);
        conf.set("fs.adl.oauth2.credential", CLIENT_SECRET);
        conf.set("fs.adl.oauth2.refresh.url", REFRESH_URL);
        conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.ClientCredential);
        this.createTempCredProvider(conf);
        URI uri = new URI("adl://localhost:8080");
        AdlFileSystem fileSystem = new AdlFileSystem();
        fileSystem.initialize(uri, conf);
        ClientCredsTokenProvider expected = new ClientCredsTokenProvider(REFRESH_URL, CLIENT_ID, CLIENT_SECRET);
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)expected, (Object)fileSystem.getTokenProvider()));
    }

    @Test
    public void testCredentialProviderPathExclusions() throws Exception {
        String providerPath = "user:///,jceks://adl/user/hrt_qa/sqoopdbpasswd.jceks,jceks://hdfs@nn1.example.com/my/path/test.jceks";
        Configuration config = new Configuration();
        config.set("hadoop.security.credential.provider.path", providerPath);
        String newPath = "user:///,jceks://hdfs@nn1.example.com/my/path/test.jceks";
        this.excludeAndTestExpectations(config, newPath);
    }

    @Test
    public void testExcludeAllProviderTypesFromConfig() throws Exception {
        String providerPath = "jceks://adl/tmp/test.jceks,jceks://adl@/my/path/test.jceks";
        Configuration config = new Configuration();
        config.set("hadoop.security.credential.provider.path", providerPath);
        String newPath = null;
        this.excludeAndTestExpectations(config, newPath);
    }

    void excludeAndTestExpectations(Configuration config, String newPath) throws Exception {
        Configuration conf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)config, AdlFileSystem.class);
        String effectivePath = conf.get("hadoop.security.credential.provider.path", null);
        Assert.assertEquals((Object)newPath, (Object)effectivePath);
    }
}

