/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.common.Parallelized;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parallelized.class)
public class TestAdlPermissionLive {
    private static Path testRoot = new Path("/test");
    private FsPermission permission;
    private Path path;
    private FileSystem adlStore;

    public TestAdlPermissionLive(FsPermission testPermission) {
        this.permission = testPermission;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection adlCreateNonRecursiveTestData() throws UnsupportedEncodingException {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        for (FsAction g : FsAction.values()) {
            for (FsAction o : FsAction.values()) {
                datas.add(new Object[]{new FsPermission(FsAction.ALL, g, o)});
            }
        }
        return datas;
    }

    @AfterClass
    public static void cleanUp() throws IOException, URISyntaxException {
        if (AdlStorageConfiguration.isContractTestEnabled()) {
            Assert.assertTrue((boolean)AdlStorageConfiguration.createStorageConnector().delete(testRoot, true));
        }
    }

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
        this.adlStore = AdlStorageConfiguration.createStorageConnector();
    }

    @Test
    public void testFilePermission() throws IOException {
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        this.adlStore.getConf().set("fs.permissions.umask-mode", "000");
        this.adlStore.mkdirs(this.path.getParent(), new FsPermission(FsAction.ALL, FsAction.WRITE, FsAction.NONE));
        this.adlStore.removeDefaultAcl(this.path.getParent());
        this.adlStore.create(this.path, this.permission, true, 1024, (short)1, 1023L, null);
        FileStatus status = this.adlStore.getFileStatus(this.path);
        Assert.assertEquals((Object)this.permission, (Object)status.getPermission());
    }

    @Test
    public void testFolderPermission() throws IOException {
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        this.adlStore.getConf().set("fs.permissions.umask-mode", "000");
        this.adlStore.mkdirs(this.path.getParent(), new FsPermission(FsAction.ALL, FsAction.WRITE, FsAction.NONE));
        this.adlStore.removeDefaultAcl(this.path.getParent());
        this.adlStore.mkdirs(this.path, this.permission);
        FileStatus status = this.adlStore.getFileStatus(this.path);
        Assert.assertEquals((Object)this.permission, (Object)status.getPermission());
    }
}

