/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.TestableAdlFileSystem;
import org.apache.hadoop.fs.adl.TokenProviderType;
import org.apache.hadoop.fs.adl.common.CustomMockTokenProvider;
import org.apache.hadoop.fs.adl.oauth2.AzureADTokenProvider;
import org.junit.After;
import org.junit.Before;

public class AdlMockWebServer {
    private MockWebServer server = null;
    private TestableAdlFileSystem fs = null;
    private int port = 0;
    private Configuration conf = new Configuration();

    public MockWebServer getMockServer() {
        return this.server;
    }

    public TestableAdlFileSystem getMockAdlFileSystem() {
        return this.fs;
    }

    public int getPort() {
        return this.port;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Before
    public void preTestSetup() throws IOException, URISyntaxException {
        this.server = new MockWebServer();
        this.server.start();
        URL baseUrl = this.server.getUrl("");
        this.port = baseUrl.getPort();
        this.fs = new TestableAdlFileSystem();
        this.conf.setEnum("fs.adl.oauth2.access.token.provider.type", (Enum)TokenProviderType.Custom);
        this.conf.setClass("fs.adl.oauth2.access.token.provider", CustomMockTokenProvider.class, AzureADTokenProvider.class);
        URI uri = new URI("adl://localhost:" + this.port);
        this.fs.initialize(uri, this.conf);
    }

    @After
    public void postTestSetup() throws IOException {
        this.fs.close();
        this.server.shutdown();
    }
}

