/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.squareup.okhttp.mockwebserver.MockResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlMockWebServer;
import org.apache.hadoop.fs.adl.TestADLResponseData;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.junit.Assert;
import org.junit.Test;

public class TestACLFeatures
extends AdlMockWebServer {
    @Test(expected=AccessControlException.class)
    public void testModifyAclEntries() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        ArrayList<AclEntry> entries = new ArrayList<AclEntry>();
        AclEntry.Builder aclEntryBuilder = new AclEntry.Builder();
        aclEntryBuilder.setName("hadoop");
        aclEntryBuilder.setType(AclEntryType.USER);
        aclEntryBuilder.setPermission(FsAction.ALL);
        aclEntryBuilder.setScope(AclEntryScope.ACCESS);
        entries.add(aclEntryBuilder.build());
        aclEntryBuilder.setName("hdfs");
        aclEntryBuilder.setType(AclEntryType.GROUP);
        aclEntryBuilder.setPermission(FsAction.READ_WRITE);
        aclEntryBuilder.setScope(AclEntryScope.DEFAULT);
        entries.add(aclEntryBuilder.build());
        this.getMockAdlFileSystem().modifyAclEntries(new Path("/test1/test2"), entries);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().modifyAclEntries(new Path("/test1/test2"), entries);
    }

    @Test(expected=AccessControlException.class)
    public void testRemoveAclEntriesWithOnlyUsers() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        ArrayList<AclEntry> entries = new ArrayList<AclEntry>();
        AclEntry.Builder aclEntryBuilder = new AclEntry.Builder();
        aclEntryBuilder.setName("hadoop");
        aclEntryBuilder.setType(AclEntryType.USER);
        entries.add(aclEntryBuilder.build());
        this.getMockAdlFileSystem().removeAclEntries(new Path("/test1/test2"), entries);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().removeAclEntries(new Path("/test1/test2"), entries);
    }

    @Test(expected=AccessControlException.class)
    public void testRemoveAclEntries() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        ArrayList<AclEntry> entries = new ArrayList<AclEntry>();
        AclEntry.Builder aclEntryBuilder = new AclEntry.Builder();
        aclEntryBuilder.setName("hadoop");
        aclEntryBuilder.setType(AclEntryType.USER);
        aclEntryBuilder.setPermission(FsAction.ALL);
        aclEntryBuilder.setScope(AclEntryScope.ACCESS);
        entries.add(aclEntryBuilder.build());
        aclEntryBuilder.setName("hdfs");
        aclEntryBuilder.setType(AclEntryType.GROUP);
        aclEntryBuilder.setPermission(FsAction.READ_WRITE);
        aclEntryBuilder.setScope(AclEntryScope.DEFAULT);
        entries.add(aclEntryBuilder.build());
        this.getMockAdlFileSystem().removeAclEntries(new Path("/test1/test2"), entries);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().removeAclEntries(new Path("/test1/test2"), entries);
    }

    @Test(expected=AccessControlException.class)
    public void testRemoveDefaultAclEntries() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().removeDefaultAcl(new Path("/test1/test2"));
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().removeDefaultAcl(new Path("/test1/test2"));
    }

    @Test(expected=AccessControlException.class)
    public void testRemoveAcl() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().removeAcl(new Path("/test1/test2"));
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().removeAcl(new Path("/test1/test2"));
    }

    @Test(expected=AccessControlException.class)
    public void testSetAcl() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        ArrayList<AclEntry> entries = new ArrayList<AclEntry>();
        AclEntry.Builder aclEntryBuilder = new AclEntry.Builder();
        aclEntryBuilder.setName("hadoop");
        aclEntryBuilder.setType(AclEntryType.USER);
        aclEntryBuilder.setPermission(FsAction.ALL);
        aclEntryBuilder.setScope(AclEntryScope.ACCESS);
        entries.add(aclEntryBuilder.build());
        aclEntryBuilder.setName("hdfs");
        aclEntryBuilder.setType(AclEntryType.GROUP);
        aclEntryBuilder.setPermission(FsAction.READ_WRITE);
        aclEntryBuilder.setScope(AclEntryScope.DEFAULT);
        entries.add(aclEntryBuilder.build());
        this.getMockAdlFileSystem().setAcl(new Path("/test1/test2"), entries);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().setAcl(new Path("/test1/test2"), entries);
    }

    @Test(expected=AccessControlException.class)
    public void testCheckAccess() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.ALL);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.EXECUTE);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.READ);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.READ_EXECUTE);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.READ_WRITE);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.NONE);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.WRITE);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.WRITE_EXECUTE);
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().access(new Path("/test1/test2"), FsAction.WRITE_EXECUTE);
    }

    @Test(expected=AccessControlException.class)
    public void testSetPermission() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().setPermission(new Path("/test1/test2"), FsPermission.getDefault());
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().setPermission(new Path("/test1/test2"), FsPermission.getDefault());
    }

    @Test(expected=AccessControlException.class)
    public void testSetOwner() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200));
        this.getMockAdlFileSystem().setOwner(new Path("/test1/test2"), "hadoop", "hdfs");
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().setOwner(new Path("/test1/test2"), "hadoop", "hdfs");
    }

    @Test
    public void getAclStatusAsExpected() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getGetAclStatusJSONResponse()));
        AclStatus aclStatus = this.getMockAdlFileSystem().getAclStatus(new Path("/test1/test2"));
        Assert.assertEquals((Object)aclStatus.getGroup(), (Object)"supergroup");
        Assert.assertEquals((Object)aclStatus.getOwner(), (Object)"hadoop");
        Assert.assertEquals((Object)aclStatus.getPermission().toShort(), (Object)Short.valueOf("775", 8));
        for (AclEntry entry : aclStatus.getEntries()) {
            if (entry.toString().equalsIgnoreCase("user:carla:rw-") || entry.toString().equalsIgnoreCase("group::r-x")) continue;
            Assert.fail((String)("Unexpected entry : " + entry.toString()));
        }
    }

    @Test(expected=FileNotFoundException.class)
    public void getAclStatusNotExists() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(404).setBody(TestADLResponseData.getFileNotFoundException()));
        this.getMockAdlFileSystem().getAclStatus(new Path("/test1/test2"));
    }

    @Test(expected=AccessControlException.class)
    public void testAclStatusDenied() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(403).setBody(TestADLResponseData.getAccessControlException()));
        this.getMockAdlFileSystem().getAclStatus(new Path("/test1/test2"));
    }
}

