/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl;

import com.squareup.okhttp.mockwebserver.MockResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.AdlMockWebServer;
import org.apache.hadoop.fs.adl.TestADLResponseData;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGetFileStatus
extends AdlMockWebServer {
    private static final Logger LOG = LoggerFactory.getLogger(TestGetFileStatus.class);

    @Test
    public void getFileStatusReturnsAsExpected() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getGetFileStatusJSONResponse()));
        long startTime = Time.monotonicNow();
        Path path = new Path("/test1/test2");
        FileStatus fileStatus = this.getMockAdlFileSystem().getFileStatus(path);
        long endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        Assert.assertTrue((boolean)fileStatus.isFile());
        Assert.assertEquals((Object)("adl://" + this.getMockServer().getHostName() + ":" + this.getMockServer().getPort() + "/test1/test2"), (Object)fileStatus.getPath().toString());
        Assert.assertEquals((long)0x400000L, (long)fileStatus.getLen());
        Assert.assertEquals((long)0x10000000L, (long)fileStatus.getBlockSize());
        Assert.assertEquals((long)1L, (long)fileStatus.getReplication());
        Assert.assertEquals((Object)new FsPermission("777"), (Object)fileStatus.getPermission());
        Assert.assertEquals((Object)"NotSupportYet", (Object)fileStatus.getOwner());
        Assert.assertEquals((Object)"NotSupportYet", (Object)fileStatus.getGroup());
        Assert.assertTrue((String)(path + " should have Acl!"), (boolean)fileStatus.hasAcl());
        Assert.assertFalse((String)(path + " should not be encrypted!"), (boolean)fileStatus.isEncrypted());
        Assert.assertFalse((String)(path + " should not be erasure coded!"), (boolean)fileStatus.isErasureCoded());
    }

    @Test
    public void getFileStatusAclBit() throws URISyntaxException, IOException {
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getGetFileStatusJSONResponse(true)));
        long startTime = Time.monotonicNow();
        FileStatus fileStatus = this.getMockAdlFileSystem().getFileStatus(new Path("/test1/test2"));
        long endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        Assert.assertTrue((boolean)fileStatus.isFile());
        Assert.assertEquals((Object)true, (Object)fileStatus.getPermission().getAclBit());
        Assert.assertEquals((Object)fileStatus.hasAcl(), (Object)fileStatus.getPermission().getAclBit());
        this.getMockServer().enqueue(new MockResponse().setResponseCode(200).setBody(TestADLResponseData.getGetFileStatusJSONResponse(false)));
        startTime = Time.monotonicNow();
        fileStatus = this.getMockAdlFileSystem().getFileStatus(new Path("/test1/test2"));
        endTime = Time.monotonicNow();
        LOG.debug("Time : " + (endTime - startTime));
        Assert.assertTrue((boolean)fileStatus.isFile());
        Assert.assertEquals((Object)false, (Object)fileStatus.getPermission().getAclBit());
        Assert.assertEquals((Object)fileStatus.hasAcl(), (Object)fileStatus.getPermission().getAclBit());
    }
}

