/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.DelegateToFileSystem;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextMainOperationsBaseTest;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.apache.hadoop.util.Shell;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAdlFileContextMainOperationsLive
extends FileContextMainOperationsBaseTest {
    private static final String KEY_FILE_SYSTEM = "test.fs.adl.name";

    @BeforeClass
    public static void skipTestCheck() {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
    }

    public void setUp() throws Exception {
        Configuration conf = AdlStorageConfiguration.getConfiguration();
        String fileSystem = conf.get(KEY_FILE_SYSTEM);
        if (fileSystem == null || fileSystem.trim().length() == 0) {
            throw new Exception("Default file system not configured.");
        }
        URI uri = new URI(fileSystem);
        FileSystem fs = AdlStorageConfiguration.createStorageConnector();
        fc = FileContext.getFileContext((AbstractFileSystem)new DelegateToFileSystem(uri, fs, conf, fs.getScheme(), false){}, (Configuration)conf);
        super.setUp();
    }

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper(UUID.randomUUID().toString());
    }

    protected boolean listCorruptedBlocksSupported() {
        return false;
    }

    public void testWorkingDirectory() throws Exception {
        if (Shell.WINDOWS) {
            Assume.assumeTrue((boolean)false);
        } else {
            super.testWorkingDirectory();
        }
    }

    public void testUnsupportedSymlink() throws IOException {
        Assume.assumeTrue((boolean)false);
    }

    @Test
    public void testSetVerifyChecksum() throws IOException {
        Assume.assumeTrue((boolean)false);
    }
}

