/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.FileNotFoundException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.ExceptionHandlingTestHelper;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestFileSystemOperationExceptionHandling
extends AbstractWasbTestBase {
    private FSDataInputStream inputStream = null;
    private static Path testPath = new Path("testfile.dat");
    private static Path testFolderPath = new Path("testfolder");

    private void setupInputStreamToTest(AzureBlobStorageTestAccount testAccount) throws Exception {
        NativeAzureFileSystem fs = testAccount.getFileSystem();
        Path testFilePath1 = new Path("test1.dat");
        Path testFilePath2 = new Path("test2.dat");
        FSDataOutputStream outputStream = fs.create(testFilePath1);
        String testString = "This is a test string";
        outputStream.write(testString.getBytes());
        outputStream.close();
        this.inputStream = fs.open(testFilePath1);
        fs.rename(testFilePath1, testFilePath2);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobReadScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = ExceptionHandlingTestHelper.getPageBlobTestStorageAccount();
        this.setupInputStreamToTest(testAccount);
        byte[] readBuffer = new byte[512];
        this.inputStream.read(readBuffer);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobSeekScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = ExceptionHandlingTestHelper.getPageBlobTestStorageAccount();
        this.setupInputStreamToTest(testAccount);
        this.inputStream.seek(5L);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadBlockBlobSeekScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = this.createTestAccount();
        this.setupInputStreamToTest(testAccount);
        this.inputStream.seek(5L);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingledThreadBlockBlobReadScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = this.createTestAccount();
        this.setupInputStreamToTest(testAccount);
        byte[] readBuffer = new byte[512];
        this.inputStream.read(readBuffer);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedBlockBlobSetPermissionScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), testPath);
        this.fs.delete(testPath, true);
        this.fs.setPermission(testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobSetPermissionScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testPath);
        this.fs.delete(testPath, true);
        this.fs.setOwner(testPath, "testowner", "testgroup");
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedBlockBlobSetOwnerScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), testPath);
        this.fs.delete(testPath, true);
        this.fs.setOwner(testPath, "testowner", "testgroup");
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobSetOwnerScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testPath);
        this.fs.delete(testPath, true);
        this.fs.setPermission(testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedBlockBlobListStatusScenario() throws Throwable {
        ExceptionHandlingTestHelper.createTestFolder(this.createTestAccount(), testFolderPath);
        this.fs.delete(testFolderPath, true);
        this.fs.listStatus(testFolderPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobListStatusScenario() throws Throwable {
        ExceptionHandlingTestHelper.createTestFolder(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testFolderPath);
        this.fs.delete(testFolderPath, true);
        this.fs.listStatus(testFolderPath);
    }

    @Test
    public void testSingleThreadedBlockBlobRenameScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), testPath);
        Path dstPath = new Path("dstFile.dat");
        this.fs.delete(testPath, true);
        boolean renameResult = this.fs.rename(testPath, dstPath);
        Assert.assertFalse((boolean)renameResult);
    }

    @Test
    public void testSingleThreadedPageBlobRenameScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testPath);
        Path dstPath = new Path("dstFile.dat");
        this.fs.delete(testPath, true);
        boolean renameResult = this.fs.rename(testPath, dstPath);
        Assert.assertFalse((boolean)renameResult);
    }

    @Test
    public void testSingleThreadedBlockBlobDeleteScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), testPath);
        this.fs.delete(testPath, true);
        boolean deleteResult = this.fs.delete(testPath, true);
        Assert.assertFalse((boolean)deleteResult);
    }

    @Test
    public void testSingleThreadedPageBlobDeleteScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testPath);
        this.fs.delete(testPath, true);
        boolean deleteResult = this.fs.delete(testPath, true);
        Assert.assertFalse((boolean)deleteResult);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedBlockBlobOpenScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), testPath);
        this.fs.delete(testPath, true);
        this.inputStream = this.fs.open(testPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobOpenScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testPath);
        this.fs.delete(testPath, true);
        this.inputStream = this.fs.open(testPath);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.fs != null && this.fs.exists(testPath)) {
            this.fs.delete(testPath, true);
        }
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }
}

