/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeAzureFileSystemBaseTest;
import org.junit.Assert;
import org.junit.Test;

public class TestFileSystemOperationExceptionMessage
extends NativeAzureFileSystemBaseTest {
    @Test
    public void testAnonymouseCredentialExceptionMessage() throws Throwable {
        Configuration conf = AzureBlobStorageTestAccount.createTestConfiguration();
        String testStorageAccount = conf.get("fs.azure.test.account.name");
        conf = new Configuration();
        conf.set("fs.AbstractFileSystem.wasb.impl", "org.apache.hadoop.fs.azure.Wasb");
        conf.set("fs.azure.skip.metrics", "true");
        String testContainer = UUID.randomUUID().toString();
        String wasbUri = String.format("wasb://%s@%s", testContainer, testStorageAccount);
        String expectedErrorMessage = String.format("Container %s in account %s not found, and we can't create it using anoynomous credentials, and no credentials found for them in the configuration.", testContainer, testStorageAccount);
        this.fs = new NativeAzureFileSystem();
        try {
            this.fs.initialize(new URI(wasbUri), conf);
        }
        catch (Exception ex) {
            Throwable innerException;
            for (innerException = ex.getCause(); innerException != null && !(innerException instanceof AzureException); innerException = innerException.getCause()) {
            }
            if (innerException != null) {
                String exceptionMessage = innerException.getMessage();
                if (exceptionMessage == null || exceptionMessage.length() == 0) {
                    Assert.fail();
                } else {
                    Assert.assertTrue((boolean)exceptionMessage.equals(expectedErrorMessage));
                }
            }
            Assert.fail();
        }
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }
}

