/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.InMemoryBlockBlobStore;
import org.apache.hadoop.fs.azure.WasbFsck;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNativeAzureFileSystemFileNameCheck {
    private FileSystem fs = null;
    private AzureBlobStorageTestAccount testAccount = null;
    private String root = null;

    @Before
    public void setUp() throws Exception {
        this.testAccount = AzureBlobStorageTestAccount.createMock();
        this.fs = this.testAccount.getFileSystem();
        this.root = this.fs.getUri().toString();
    }

    @After
    public void tearDown() throws Exception {
        this.testAccount.cleanup();
        this.root = null;
        this.fs = null;
        this.testAccount = null;
    }

    @Test
    public void testCreate() throws Exception {
        Path testFile1 = new Path(this.root + "/testFile1");
        Assert.assertTrue((boolean)this.fs.createNewFile(testFile1));
        Path testFile2 = new Path(this.root + "/testFile2:2");
        try {
            this.fs.createNewFile(testFile2);
            Assert.fail((String)"Should've thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRename() throws Exception {
        Path testFile1 = new Path(this.root + "/testFile1");
        Assert.assertTrue((boolean)this.fs.createNewFile(testFile1));
        Path testFile2 = new Path(this.root + "/testFile2");
        this.fs.rename(testFile1, testFile2);
        Assert.assertTrue((!this.fs.exists(testFile1) && this.fs.exists(testFile2) ? 1 : 0) != 0);
        Path testFile3 = new Path(this.root + "/testFile3:3");
        try {
            this.fs.rename(testFile2, testFile3);
            Assert.fail((String)"Should've thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.fs.exists(testFile2));
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testFolder1 = new Path(this.root + "/testFolder1");
        Assert.assertTrue((boolean)this.fs.mkdirs(testFolder1));
        Path testFolder2 = new Path(this.root + "/testFolder2:2");
        try {
            Assert.assertTrue((boolean)this.fs.mkdirs(testFolder2));
            Assert.fail((String)"Should've thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testWasbFsck() throws Exception {
        Path testFolder1 = new Path(this.root + "/testFolder1");
        Assert.assertTrue((boolean)this.fs.mkdirs(testFolder1));
        Path testFolder2 = new Path(testFolder1, "testFolder2");
        Assert.assertTrue((boolean)this.fs.mkdirs(testFolder2));
        Path testFolder3 = new Path(testFolder1, "testFolder3");
        Assert.assertTrue((boolean)this.fs.mkdirs(testFolder3));
        Path testFile1 = new Path(testFolder2, "testFile1");
        Assert.assertTrue((boolean)this.fs.createNewFile(testFile1));
        Path testFile2 = new Path(testFolder1, "testFile2");
        Assert.assertTrue((boolean)this.fs.createNewFile(testFile2));
        Assert.assertFalse((boolean)this.runWasbFsck(testFolder1));
        InMemoryBlockBlobStore backingStore = this.testAccount.getMockStorage().getBackingStore();
        backingStore.setContent(AzureBlobStorageTestAccount.toMockUri("testFolder1/testFolder2/test2:2"), new byte[]{1, 2}, new HashMap<String, String>(), false, 0L);
        Assert.assertTrue((boolean)this.runWasbFsck(testFolder1));
    }

    private boolean runWasbFsck(Path p) throws Exception {
        WasbFsck fsck = new WasbFsck(this.fs.getConf());
        fsck.setMockFileSystemForTesting(this.fs);
        fsck.run(new String[]{p.toString()});
        return fsck.getPathNameWarning();
    }
}

