/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWasbTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractWasbTestBase.class);
    protected FileSystem fs;
    private AzureBlobStorageTestAccount testAccount;

    @Before
    public void setUp() throws Exception {
        this.testAccount = this.createTestAccount();
        if (this.testAccount != null) {
            this.fs = this.testAccount.getFileSystem();
        }
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
    }

    @After
    public void tearDown() throws Exception {
        if (this.testAccount != null) {
            this.testAccount.cleanup();
            this.testAccount = null;
            this.fs = null;
        }
    }

    protected abstract AzureBlobStorageTestAccount createTestAccount() throws Exception;
}

