/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.FileNotFoundException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.DeleteThread;
import org.apache.hadoop.fs.azure.ExceptionHandlingTestHelper;
import org.apache.hadoop.fs.azure.RenameThread;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Test;

public class TestFileSystemOperationsExceptionHandlingMultiThreaded
extends AbstractWasbTestBase {
    FSDataInputStream inputStream = null;
    private static Path testPath = new Path("testfile.dat");
    private static Path testFolderPath = new Path("testfolder");

    private void getInputStreamToTest(FileSystem fs, Path testPath) throws Throwable {
        FSDataOutputStream outputStream = fs.create(testPath);
        String testString = "This is a test string";
        outputStream.write(testString.getBytes());
        outputStream.close();
        this.inputStream = fs.open(testPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobReadScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = this.createTestAccount();
        this.fs = testAccount.getFileSystem();
        Path testFilePath1 = new Path("test1.dat");
        this.getInputStreamToTest(this.fs, testFilePath1);
        Thread renameThread = new Thread(new RenameThread(this.fs, testFilePath1));
        renameThread.start();
        renameThread.join();
        byte[] readBuffer = new byte[512];
        this.inputStream.read(readBuffer);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadBlockBlobSeekScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = this.createTestAccount();
        this.fs = testAccount.getFileSystem();
        Path testFilePath1 = new Path("test1.dat");
        this.getInputStreamToTest(this.fs, testFilePath1);
        Thread renameThread = new Thread(new RenameThread(this.fs, testFilePath1));
        renameThread.start();
        renameThread.join();
        this.inputStream.seek(5L);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobSetPermissionScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testPath);
        Thread t = new Thread(new DeleteThread(this.fs, testPath));
        t.start();
        while (t.isAlive()) {
            this.fs.setPermission(testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
        }
        this.fs.setPermission(testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobSetPermissionScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), testPath);
        Thread t = new Thread(new DeleteThread(this.fs, testPath));
        t.start();
        while (t.isAlive()) {
            this.fs.setPermission(testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
        }
        this.fs.setPermission(testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobOpenScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), testPath);
        Thread t = new Thread(new DeleteThread(this.fs, testPath));
        t.start();
        while (t.isAlive()) {
            this.inputStream = this.fs.open(testPath);
            this.inputStream.close();
        }
        this.inputStream = this.fs.open(testPath);
        this.inputStream.close();
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobOpenScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testPath);
        Thread t = new Thread(new DeleteThread(this.fs, testPath));
        t.start();
        while (t.isAlive()) {
            this.inputStream = this.fs.open(testPath);
            this.inputStream.close();
        }
        this.inputStream = this.fs.open(testPath);
        this.inputStream.close();
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobSetOwnerScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), testPath);
        Thread t = new Thread(new DeleteThread(this.fs, testPath));
        t.start();
        while (t.isAlive()) {
            this.fs.setOwner(testPath, "testowner", "testgroup");
        }
        this.fs.setOwner(testPath, "testowner", "testgroup");
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobSetOwnerScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testPath);
        Thread t = new Thread(new DeleteThread(this.fs, testPath));
        t.start();
        while (t.isAlive()) {
            this.fs.setOwner(testPath, "testowner", "testgroup");
        }
        this.fs.setOwner(testPath, "testowner", "testgroup");
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedBlockBlobListStatusScenario() throws Throwable {
        ExceptionHandlingTestHelper.createTestFolder(this.createTestAccount(), testFolderPath);
        Thread t = new Thread(new DeleteThread(this.fs, testFolderPath));
        t.start();
        while (t.isAlive()) {
            this.fs.listStatus(testFolderPath);
        }
        this.fs.listStatus(testFolderPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobListStatusScenario() throws Throwable {
        ExceptionHandlingTestHelper.createTestFolder(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), testFolderPath);
        Thread t = new Thread(new DeleteThread(this.fs, testFolderPath));
        t.start();
        while (t.isAlive()) {
            this.fs.listStatus(testFolderPath);
        }
        this.fs.listStatus(testFolderPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobReadScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = ExceptionHandlingTestHelper.getPageBlobTestStorageAccount();
        this.fs = testAccount.getFileSystem();
        Path testFilePath1 = new Path("test1.dat");
        this.getInputStreamToTest(this.fs, testFilePath1);
        Thread renameThread = new Thread(new RenameThread(this.fs, testFilePath1));
        renameThread.start();
        renameThread.join();
        byte[] readBuffer = new byte[512];
        this.inputStream.read(readBuffer);
    }

    @Test(expected=FileNotFoundException.class)
    public void testMultiThreadedPageBlobSeekScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = ExceptionHandlingTestHelper.getPageBlobTestStorageAccount();
        this.fs = testAccount.getFileSystem();
        Path testFilePath1 = new Path("test1.dat");
        this.getInputStreamToTest(this.fs, testFilePath1);
        Thread renameThread = new Thread(new RenameThread(this.fs, testFilePath1));
        renameThread.start();
        renameThread.join();
        this.inputStream.seek(5L);
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.fs != null && this.fs.exists(testPath)) {
            this.fs.delete(testPath, true);
        }
    }
}

