/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNativeAzureFileSystemAppend
extends AbstractWasbTestBase {
    private static final String TEST_FILE = "test.dat";
    private static final Path TEST_PATH = new Path("test.dat");
    private AzureBlobStorageTestAccount testAccount = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.testAccount = this.createTestAccount();
        this.fs = this.testAccount.getFileSystem();
        Configuration conf = this.fs.getConf();
        conf.setBoolean("fs.azure.enable.append.support", true);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
    }

    private static byte[] getTestData(int size) {
        byte[] testData = new byte[size];
        System.arraycopy(RandomStringUtils.randomAlphabetic((int)size).getBytes(), 0, testData, 0, size);
        return testData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createBaseFileWithData(int fileSize, Path testPath) throws Throwable {
        try (FSDataOutputStream createStream = null;){
            createStream = this.fs.create(testPath);
            byte[] fileData = null;
            if (fileSize != 0) {
                fileData = TestNativeAzureFileSystemAppend.getTestData(fileSize);
                createStream.write(fileData);
            }
            byte[] byArray = fileData;
            return byArray;
        }
    }

    private boolean verifyFileData(int dataLength, byte[] testData, int testDataIndex, FSDataInputStream srcStream) {
        try {
            byte[] fileBuffer = new byte[dataLength];
            byte[] testDataBuffer = new byte[dataLength];
            int fileBytesRead = srcStream.read(fileBuffer);
            if (fileBytesRead < dataLength) {
                return false;
            }
            System.arraycopy(testData, testDataIndex, testDataBuffer, 0, dataLength);
            return Arrays.equals(fileBuffer, testDataBuffer);
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyAppend(byte[] testData, Path testFile) {
        FSDataInputStream srcStream = null;
        try {
            int testDataSize;
            srcStream = this.fs.open(testFile);
            int baseBufferSize = 2048;
            int testDataIndex = 0;
            for (testDataSize = testData.length; testDataSize > baseBufferSize; testDataSize -= baseBufferSize) {
                if (!this.verifyFileData(baseBufferSize, testData, testDataIndex, srcStream)) {
                    boolean bl = false;
                    return bl;
                }
                testDataIndex += baseBufferSize;
            }
            if (!this.verifyFileData(testDataSize, testData, testDataIndex, srcStream)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (srcStream != null) {
                try {
                    srcStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleAppend() throws Throwable {
        try (FSDataOutputStream appendStream = null;){
            int baseDataSize = 50;
            byte[] baseDataBuffer = this.createBaseFileWithData(baseDataSize, TEST_PATH);
            int appendDataSize = 20;
            byte[] appendDataBuffer = TestNativeAzureFileSystemAppend.getTestData(appendDataSize);
            appendStream = this.fs.append(TEST_PATH, 10);
            appendStream.write(appendDataBuffer);
            appendStream.close();
            byte[] testData = new byte[baseDataSize + appendDataSize];
            System.arraycopy(baseDataBuffer, 0, testData, 0, baseDataSize);
            System.arraycopy(appendDataBuffer, 0, testData, baseDataSize, appendDataSize);
            Assert.assertTrue((boolean)this.verifyAppend(testData, TEST_PATH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleAppendOnEmptyFile() throws Throwable {
        try (FSDataOutputStream appendStream = null;){
            this.createBaseFileWithData(0, TEST_PATH);
            int appendDataSize = 20;
            byte[] appendDataBuffer = TestNativeAzureFileSystemAppend.getTestData(appendDataSize);
            appendStream = this.fs.append(TEST_PATH, 10);
            appendStream.write(appendDataBuffer);
            appendStream.close();
            Assert.assertTrue((boolean)this.verifyAppend(appendDataBuffer, TEST_PATH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleAppenderScenario() throws Throwable {
        FSDataOutputStream appendStream1 = null;
        FSDataOutputStream appendStream2 = null;
        IOException ioe = null;
        try {
            this.createBaseFileWithData(0, TEST_PATH);
            appendStream1 = this.fs.append(TEST_PATH, 10);
            boolean encounteredException = false;
            try {
                appendStream2 = this.fs.append(TEST_PATH, 10);
            }
            catch (IOException ex) {
                encounteredException = true;
                ioe = ex;
            }
            appendStream1.close();
            Assert.assertTrue((boolean)encounteredException);
            GenericTestUtils.assertExceptionContains((String)"Unable to set Append lease on the Blob", (Throwable)ioe);
        }
        finally {
            if (appendStream1 != null) {
                appendStream1.close();
            }
            if (appendStream2 != null) {
                appendStream2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleAppends() throws Throwable {
        int baseDataSize = 50;
        byte[] baseDataBuffer = this.createBaseFileWithData(baseDataSize, TEST_PATH);
        int appendDataSize = 100;
        int targetAppendCount = 50;
        byte[] testData = new byte[baseDataSize + appendDataSize * targetAppendCount];
        int testDataIndex = 0;
        System.arraycopy(baseDataBuffer, 0, testData, testDataIndex, baseDataSize);
        testDataIndex += baseDataSize;
        try (FSDataOutputStream appendStream = null;){
            for (int appendCount = 0; appendCount < targetAppendCount; ++appendCount) {
                byte[] appendDataBuffer = TestNativeAzureFileSystemAppend.getTestData(appendDataSize);
                appendStream = this.fs.append(TEST_PATH, 30);
                appendStream.write(appendDataBuffer);
                appendStream.close();
                System.arraycopy(appendDataBuffer, 0, testData, testDataIndex, appendDataSize);
                testDataIndex += appendDataSize;
            }
            Assert.assertTrue((boolean)this.verifyAppend(testData, TEST_PATH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleAppendsOnSameStream() throws Throwable {
        int baseDataSize = 50;
        byte[] baseDataBuffer = this.createBaseFileWithData(baseDataSize, TEST_PATH);
        int appendDataSize = 100;
        int targetAppendCount = 50;
        byte[] testData = new byte[baseDataSize + appendDataSize * targetAppendCount];
        int testDataIndex = 0;
        System.arraycopy(baseDataBuffer, 0, testData, testDataIndex, baseDataSize);
        testDataIndex += baseDataSize;
        try (FSDataOutputStream appendStream = null;){
            for (int appendCount = 0; appendCount < targetAppendCount; ++appendCount) {
                appendStream = this.fs.append(TEST_PATH, 50);
                int singleAppendChunkSize = 20;
                for (int appendRunSize = 0; appendRunSize < appendDataSize; appendRunSize += singleAppendChunkSize) {
                    byte[] appendDataBuffer = TestNativeAzureFileSystemAppend.getTestData(singleAppendChunkSize);
                    appendStream.write(appendDataBuffer);
                    System.arraycopy(appendDataBuffer, 0, testData, testDataIndex + appendRunSize, singleAppendChunkSize);
                }
                appendStream.close();
                testDataIndex += appendDataSize;
            }
            Assert.assertTrue((boolean)this.verifyAppend(testData, TEST_PATH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=UnsupportedOperationException.class)
    public void testFalseConfigurationFlagBehavior() throws Throwable {
        this.fs = this.testAccount.getFileSystem();
        Configuration conf = this.fs.getConf();
        conf.setBoolean("fs.azure.enable.append.support", false);
        URI uri = this.fs.getUri();
        this.fs.initialize(uri, conf);
        try (FSDataOutputStream appendStream = null;){
            this.createBaseFileWithData(0, TEST_PATH);
            appendStream = this.fs.append(TEST_PATH, 10);
        }
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }
}

