/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.StorageException;
import java.io.Closeable;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.NativeAzureFileSystemBaseTest;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNativeAzureFileSystemLive
extends NativeAzureFileSystemBaseTest {
    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Test
    public void testLazyRenamePendingCanOverwriteExistingFile() throws Exception {
        String SRC_FILE_KEY = "srcFile";
        String DST_FILE_KEY = "dstFile";
        Path srcPath = new Path("srcFile");
        FSDataOutputStream srcStream = this.fs.create(srcPath);
        Assert.assertTrue((boolean)this.fs.exists(srcPath));
        Path dstPath = new Path("dstFile");
        FSDataOutputStream dstStream = this.fs.create(dstPath);
        Assert.assertTrue((boolean)this.fs.exists(dstPath));
        NativeAzureFileSystem nfs = (NativeAzureFileSystem)this.fs;
        String fullSrcKey = nfs.pathToKey(nfs.makeAbsolute(srcPath));
        String fullDstKey = nfs.pathToKey(nfs.makeAbsolute(dstPath));
        nfs.getStoreInterface().rename(fullSrcKey, fullDstKey, true, null);
        Assert.assertTrue((boolean)this.fs.exists(dstPath));
        Assert.assertFalse((boolean)this.fs.exists(srcPath));
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{srcStream});
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{dstStream});
    }

    @Test
    public void testDeleteThrowsExceptionWithLeaseExistsErrorMessage() throws Exception {
        LOG.info((Object)"Starting test");
        String FILE_KEY = "fileWithLease";
        Path path = new Path("fileWithLease");
        this.fs.create(path);
        Assert.assertTrue((boolean)this.fs.exists(path));
        NativeAzureFileSystem nfs = (NativeAzureFileSystem)this.fs;
        final String fullKey = nfs.pathToKey(nfs.makeAbsolute(path));
        final AzureNativeFileSystemStore store = nfs.getStore();
        final CountDownLatch leaseAttemptComplete = new CountDownLatch(1);
        final CountDownLatch beginningDeleteAttempt = new CountDownLatch(1);
        Thread t = new Thread(){

            @Override
            public void run() {
                SelfRenewingLease lease = null;
                try {
                    lease = store.acquireLease(fullKey);
                    NativeAzureFileSystemBaseTest.LOG.info((Object)("Lease acquired: " + lease.getLeaseID()));
                }
                catch (AzureException e) {
                    NativeAzureFileSystemBaseTest.LOG.warn((Object)"Lease acqusition thread unable to acquire lease", (Throwable)e);
                }
                finally {
                    leaseAttemptComplete.countDown();
                }
                try {
                    beginningDeleteAttempt.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                try {
                    if (lease != null) {
                        NativeAzureFileSystemBaseTest.LOG.info((Object)"Freeing lease");
                        lease.free();
                    }
                }
                catch (StorageException se) {
                    NativeAzureFileSystemBaseTest.LOG.warn((Object)"Unable to free lease.", (Throwable)se);
                }
            }
        };
        t.start();
        try {
            leaseAttemptComplete.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        beginningDeleteAttempt.countDown();
        store.delete(fullKey);
        Assert.assertFalse((boolean)this.fs.exists(path));
    }

    @Test
    public void testIsPageBlobKey() {
        String[] positiveKeys;
        String[] negativeKeys;
        AzureNativeFileSystemStore store = ((NativeAzureFileSystem)this.fs).getStore();
        Assert.assertEquals((Object)"pageBlobs", (Object)"pageBlobs");
        String uriPrefix = "file:///";
        for (String s : negativeKeys = new String[]{"", "/", "bar", "bar/", "bar/pageBlobs", "bar/pageBlobs/foo", "bar/pageBlobs/foo/", "/pageBlobs/", "/pageBlobs", "pageBlobs", "pageBlobsxyz/"}) {
            Assert.assertFalse((boolean)store.isPageBlobKey(s));
            Assert.assertFalse((boolean)store.isPageBlobKey(uriPrefix + s));
        }
        for (String s : positiveKeys = new String[]{"pageBlobs/", "pageBlobs/foo/", "pageBlobs/foo/bar/"}) {
            Assert.assertTrue((boolean)store.isPageBlobKey(s));
            Assert.assertTrue((boolean)store.isPageBlobKey(uriPrefix + s));
        }
    }

    @Test
    public void testIsAtomicRenameKey() {
        String[] positiveKeys;
        String[] negativeKeys;
        AzureNativeFileSystemStore store = ((NativeAzureFileSystem)this.fs).getStore();
        Assert.assertEquals((Object)"/atomicRenameDir1,/atomicRenameDir2", (Object)"/atomicRenameDir1,/atomicRenameDir2");
        String uriPrefix = "file:///";
        for (String s : negativeKeys = new String[]{"", "/", "bar", "bar/", "bar/hbase", "bar/hbase/foo", "bar/hbase/foo/", "/hbase/", "/hbase", "hbase", "hbasexyz/", "foo/atomicRenameDir1/"}) {
            Assert.assertFalse((boolean)store.isAtomicRenameKey(s));
            Assert.assertFalse((boolean)store.isAtomicRenameKey(uriPrefix + s));
        }
        for (String s : positiveKeys = new String[]{"hbase/", "hbase/foo/", "hbase/foo/bar/", "atomicRenameDir1/foo/", "atomicRenameDir2/bar/"}) {
            Assert.assertTrue((boolean)store.isAtomicRenameKey(s));
            Assert.assertTrue((boolean)store.isAtomicRenameKey(uriPrefix + s));
        }
    }

    @Test
    public void testMkdirOnExistingFolderWithLease() throws Exception {
        String FILE_KEY = "folderWithLease";
        this.fs.mkdirs(new Path("folderWithLease"));
        NativeAzureFileSystem nfs = (NativeAzureFileSystem)this.fs;
        String fullKey = nfs.pathToKey(nfs.makeAbsolute(new Path("folderWithLease")));
        AzureNativeFileSystemStore store = nfs.getStore();
        SelfRenewingLease lease = store.acquireLease(fullKey);
        Assert.assertTrue((lease.getLeaseID() != null ? 1 : 0) != 0);
        store.storeEmptyFolder(fullKey, nfs.createPermissionStatus(FsPermission.getDirDefault()));
        lease.free();
    }
}

