/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import org.apache.hadoop.fs.FSMainOperationsBaseTest;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.junit.Assume;

public class TestNativeAzureFileSystemOperationsMocked
extends FSMainOperationsBaseTest {
    private static final String TEST_ROOT_DIR = "/tmp/TestNativeAzureFileSystemOperationsMocked";

    public TestNativeAzureFileSystemOperationsMocked() {
        super(TEST_ROOT_DIR);
    }

    public void setUp() throws Exception {
        this.fSys = AzureBlobStorageTestAccount.createMock().getFileSystem();
    }

    protected FileSystem createFileSystem() throws Exception {
        return AzureBlobStorageTestAccount.createMock().getFileSystem();
    }

    public void testListStatusThrowsExceptionForUnreadableDir() throws Exception {
        System.out.println("Skipping testListStatusThrowsExceptionForUnreadableDir since WASB doesn't honor directory permissions.");
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
    }

    public String getTestRootDir() {
        return TEST_ROOT_DIR;
    }

    public Path getTestRootPath(FileSystem fSys) {
        return fSys.makeQualified(new Path(TEST_ROOT_DIR));
    }

    public Path getTestRootPath(FileSystem fSys, String pathString) {
        return fSys.makeQualified(new Path(TEST_ROOT_DIR, pathString));
    }

    public Path getAbsoluteTestRootPath(FileSystem fSys) {
        Path testRootPath = new Path(TEST_ROOT_DIR);
        if (testRootPath.isAbsolute()) {
            return testRootPath;
        }
        return new Path(fSys.getWorkingDirectory(), TEST_ROOT_DIR);
    }
}

