/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.log;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.LogAggregationWebUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class AggregatedLogsBlock
extends HtmlBlock {
    private final Configuration conf;
    private final LogAggregationFileControllerFactory factory;

    @Inject
    AggregatedLogsBlock(Configuration conf) {
        this.conf = conf;
        this.factory = new LogAggregationFileControllerFactory(conf);
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        LogAggregationFileController fileController;
        ContainerId containerId = LogAggregationWebUtils.verifyAndGetContainerId(html, this.$("container.id"));
        NodeId nodeId = LogAggregationWebUtils.verifyAndGetNodeId(html, this.$("nm.id"));
        String appOwner = LogAggregationWebUtils.verifyAndGetAppOwner(html, this.$("app.owner"));
        boolean isValid = true;
        try {
            LogAggregationWebUtils.getLogStartIndex(html, this.$("start"));
        }
        catch (NumberFormatException ne) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log start value: " + this.$("start")}))).__();
            isValid = false;
        }
        try {
            LogAggregationWebUtils.getLogEndIndex(html, this.$("end"));
        }
        catch (NumberFormatException ne) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Invalid log end value: " + this.$("end")}))).__();
            isValid = false;
        }
        if (containerId == null || nodeId == null || appOwner == null || appOwner.isEmpty() || !isValid) {
            return;
        }
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        String logEntity = this.$("entity.string");
        if (logEntity == null || logEntity.isEmpty()) {
            logEntity = containerId.toString();
        }
        String nmApplicationLogUrl = this.getApplicationLogURL(applicationId);
        if (!this.conf.getBoolean("yarn.log-aggregation-enable", false)) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Aggregation is not enabled. Try the nodemanager at " + nodeId}))).__();
            if (nmApplicationLogUrl != null) {
                ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Or see application log at " + nmApplicationLogUrl}))).__();
            }
            return;
        }
        try {
            fileController = this.factory.getFileControllerForRead(applicationId, appOwner);
        }
        catch (Exception fnf) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Logs not available for " + logEntity + ". Aggregation may not be complete, " + "Check back later or try the nodemanager at " + nodeId}))).__();
            if (nmApplicationLogUrl != null) {
                ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Or see application log at " + nmApplicationLogUrl}))).__();
            }
            return;
        }
        fileController.renderAggregatedLogsBlock(html, this.context());
    }

    private String getApplicationLogURL(ApplicationId applicationId) {
        String appId = applicationId.toString();
        if (appId == null || appId.isEmpty()) {
            return null;
        }
        String nodeId = this.$("nm.id");
        if (nodeId == null || nodeId.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String scheme = YarnConfiguration.useHttps(this.conf) ? "https://" : "http://";
        sb.append(scheme).append(nodeId).append("/node/application/").append(appId);
        return sb.toString();
    }
}

