/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.StringTokenizer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DF
extends Shell {
    public static final long DF_INTERVAL_DEFAULT = 3000L;
    private final String dirPath;
    private final File dirFile;
    private String filesystem;
    private String mount;
    private static final String OS_NAME = System.getProperty("os.name");
    private static final OSType OS_TYPE = DF.getOSType(OS_NAME);

    protected static OSType getOSType(String osName) {
        for (OSType ost : EnumSet.allOf(OSType.class)) {
            if (!ost.match(osName)) continue;
            return ost;
        }
        return OSType.OS_TYPE_UNIX;
    }

    public DF(File path, Configuration conf) throws IOException {
        this(path, conf.getLong("fs.df.interval", 3000L));
    }

    public DF(File path, long dfInterval) throws IOException {
        super(dfInterval);
        this.dirPath = path.getCanonicalPath();
        this.dirFile = new File(this.dirPath);
    }

    protected OSType getOSType() {
        return OS_TYPE;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public String getFilesystem() throws IOException {
        this.run();
        return this.filesystem;
    }

    public long getCapacity() {
        return this.dirFile.getTotalSpace();
    }

    public long getUsed() {
        return this.dirFile.getTotalSpace() - this.dirFile.getFreeSpace();
    }

    public long getAvailable() {
        return this.dirFile.getUsableSpace();
    }

    public int getPercentUsed() {
        double cap = this.getCapacity();
        double used = cap - (double)this.getAvailable();
        return (int)(used * 100.0 / cap);
    }

    public String getMount() throws IOException {
        this.run();
        return this.mount;
    }

    public String toString() {
        return "df -k " + this.mount + "\n" + this.filesystem + "\t" + this.getCapacity() / 1024L + "\t" + this.getUsed() / 1024L + "\t" + this.getAvailable() / 1024L + "\t" + this.getPercentUsed() + "%\t" + this.mount;
    }

    @Override
    protected String[] getExecString() {
        return new String[]{"bash", "-c", "exec 'df' '-k' '" + this.dirPath + "' 2>/dev/null"};
    }

    @Override
    protected void parseExecResult(BufferedReader lines) throws IOException {
        lines.readLine();
        String line = lines.readLine();
        if (line == null) {
            throw new IOException("Expecting a line not the end of stream");
        }
        StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
        this.filesystem = tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            line = lines.readLine();
            if (line == null) {
                throw new IOException("Expecting a line not the end of stream");
            }
            tokens = new StringTokenizer(line, " \t\n\r\f%");
        }
        switch (this.getOSType()) {
            case OS_TYPE_AIX: {
                Long.parseLong(tokens.nextToken());
                Long.parseLong(tokens.nextToken());
                Integer.parseInt(tokens.nextToken());
                tokens.nextToken();
                tokens.nextToken();
                this.mount = tokens.nextToken();
                break;
            }
            default: {
                Long.parseLong(tokens.nextToken());
                Long.parseLong(tokens.nextToken());
                Long.parseLong(tokens.nextToken());
                Integer.parseInt(tokens.nextToken());
                this.mount = tokens.nextToken();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String path = ".";
        if (args.length > 0) {
            path = args[0];
        }
        System.out.println(new DF(new File(path), 3000L).toString());
    }

    static enum OSType {
        OS_TYPE_UNIX("UNIX"),
        OS_TYPE_WIN("Windows"),
        OS_TYPE_SOLARIS("SunOS"),
        OS_TYPE_MAC("Mac"),
        OS_TYPE_AIX("AIX");

        private String id;

        private OSType(String id) {
            this.id = id;
        }

        public boolean match(String osStr) {
            return osStr != null && osStr.indexOf(this.id) >= 0;
        }

        String getId() {
            return this.id;
        }
    }
}

