/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public class ThreadUtil {
    private static final Log LOG = LogFactory.getLog(ThreadUtil.class);

    public static void sleepAtLeastIgnoreInterrupts(long millis) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < millis) {
            long timeToSleep = millis - (System.currentTimeMillis() - start);
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"interrupted while sleeping", (Throwable)ie);
            }
        }
    }
}

