/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ftp;

import org.apache.commons.net.ftp.FTPClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ftp.FTPFileSystem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestFTPFileSystem {
    @Rule
    public Timeout testTimeout = new Timeout(180000);

    @Test
    public void testFTPDefaultPort() throws Exception {
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)21L, (long)ftp.getDefaultPort());
    }

    @Test
    public void testFTPTransferMode() throws Exception {
        Configuration conf = new Configuration();
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)11L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "STREAM_TRANSFER_MODE");
        Assert.assertEquals((long)10L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "COMPRESSED_TRANSFER_MODE");
        Assert.assertEquals((long)12L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "invalid");
        Assert.assertEquals((long)11L, (long)ftp.getTransferMode(conf));
    }

    @Test
    public void testFTPDataConnectionMode() throws Exception {
        Configuration conf = new Configuration();
        FTPClient client = new FTPClient();
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        conf.set("fs.ftp.data.connection.mode", "invalid");
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        conf.set("fs.ftp.data.connection.mode", "PASSIVE_LOCAL_DATA_CONNECTION_MODE");
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)2L, (long)client.getDataConnectionMode());
    }
}

