/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.http.resource.JerseyResource;
import org.apache.hadoop.net.NetUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHttpServerLogs
extends HttpServerFunctionalTest {
    static final Log LOG = LogFactory.getLog(TestHttpServerLogs.class);
    private static HttpServer2 server;

    @BeforeClass
    public static void setup() throws Exception {
    }

    private void startServer(Configuration conf) throws Exception {
        server = TestHttpServerLogs.createTestServer(conf);
        server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        server.start();
        baseUrl = TestHttpServerLogs.getServerURL(server);
        LOG.info((Object)("HTTP server started: " + baseUrl));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        if (server != null && server.isAlive()) {
            server.stop();
        }
    }

    @Test
    public void testLogsEnabled() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.http.logs.enabled", true);
        this.startServer(conf);
        URL url = new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)) + "/logs");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestHttpServerLogs.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    @Test
    public void testLogsDisabled() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.http.logs.enabled", false);
        this.startServer(conf);
        URL url = new URL(baseUrl + "/logs");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestHttpServerLogs.assertEquals((long)404L, (long)conn.getResponseCode());
    }
}

