/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.ConfigUtil;
import org.apache.hadoop.metrics2.impl.MetricsConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestMetricsConfig {
    static final Log LOG = LogFactory.getLog(TestMetricsConfig.class);

    @Test
    public void testCommon() throws Exception {
        String filename = TestMetricsConfig.getTestFilename("test-metrics2");
        new ConfigBuilder().add("*.foo", "default foo").add("p1.*.bar", "p1 default bar").add("p1.t1.*.bar", "p1.t1 default bar").add("p1.t1.i1.name", "p1.t1.i1.name").add("p1.t1.42.bar", "p1.t1.42.bar").add("p1.t2.i1.foo", "p1.t2.i1.foo").add("p2.*.foo", "p2 default foo").save(filename);
        MetricsConfig mc = MetricsConfig.create((String)"p1", (String[])new String[]{filename});
        LOG.debug((Object)("mc:" + mc));
        PropertiesConfiguration expected = new ConfigBuilder().add((String)"*.bar", (Object)"p1 default bar").add((String)"t1.*.bar", (Object)"p1.t1 default bar").add((String)"t1.i1.name", (Object)"p1.t1.i1.name").add((String)"t1.42.bar", (Object)"p1.t1.42.bar").add((String)"t2.i1.foo", (Object)"p1.t2.i1.foo").config;
        ConfigUtil.assertEq((Configuration)expected, (Configuration)mc);
        this.testInstances(mc);
    }

    private void testInstances(MetricsConfig c) throws Exception {
        Map map = c.getInstanceConfigs("t1");
        Map map2 = c.getInstanceConfigs("t2");
        Assert.assertEquals((String)"number of t1 instances", (long)2L, (long)map.size());
        Assert.assertEquals((String)"number of t2 instances", (long)1L, (long)map2.size());
        Assert.assertTrue((String)"contains t1 instance i1", (boolean)map.containsKey("i1"));
        Assert.assertTrue((String)"contains t1 instance 42", (boolean)map.containsKey("42"));
        Assert.assertTrue((String)"contains t2 instance i1", (boolean)map2.containsKey("i1"));
        MetricsConfig t1i1 = (MetricsConfig)map.get("i1");
        MetricsConfig t1i42 = (MetricsConfig)map.get("42");
        MetricsConfig t2i1 = (MetricsConfig)map2.get("i1");
        LOG.debug((Object)("--- t1 instance i1:" + t1i1));
        LOG.debug((Object)("--- t1 instance 42:" + t1i42));
        LOG.debug((Object)("--- t2 instance i1:" + t2i1));
        PropertiesConfiguration t1expected1 = new ConfigBuilder().add((String)"name", (Object)"p1.t1.i1.name").config;
        PropertiesConfiguration t1expected42 = new ConfigBuilder().add((String)"bar", (Object)"p1.t1.42.bar").config;
        PropertiesConfiguration t2expected1 = new ConfigBuilder().add((String)"foo", (Object)"p1.t2.i1.foo").config;
        ConfigUtil.assertEq((Configuration)t1expected1, (Configuration)t1i1);
        ConfigUtil.assertEq((Configuration)t1expected42, (Configuration)t1i42);
        ConfigUtil.assertEq((Configuration)t2expected1, (Configuration)t2i1);
        LOG.debug((Object)"asserting foo == default foo");
        Assert.assertEquals((String)"value of foo in t1 instance i1", (Object)"default foo", (Object)t1i1.getString("foo"));
        Assert.assertEquals((String)"value of bar in t1 instance i1", (Object)"p1.t1 default bar", (Object)t1i1.getString("bar"));
        Assert.assertEquals((String)"value of foo in t1 instance 42", (Object)"default foo", (Object)t1i42.getString("foo"));
        Assert.assertEquals((String)"value of foo in t2 instance i1", (Object)"p1.t2.i1.foo", (Object)t2i1.getString("foo"));
        Assert.assertEquals((String)"value of bar in t2 instance i1", (Object)"p1 default bar", (Object)t2i1.getString("bar"));
    }

    @Test
    public void testMissingFiles() {
        MetricsConfig config = MetricsConfig.create((String)"JobTracker", (String[])new String[]{"non-existent.properties"});
        Assert.assertTrue((boolean)config.isEmpty());
    }

    @Test
    public void testLoadFirst() throws Exception {
        String filename = TestMetricsConfig.getTestFilename("hadoop-metrics2-p1");
        new ConfigBuilder().add("p1.foo", "p1foo").save(filename);
        MetricsConfig mc = MetricsConfig.create((String)"p1");
        MetricsConfig mc2 = MetricsConfig.create((String)"p1", (String[])new String[]{"na1", "na2", filename});
        PropertiesConfiguration expected = new ConfigBuilder().add((String)"foo", (Object)"p1foo").config;
        ConfigUtil.assertEq((Configuration)expected, (Configuration)mc);
        ConfigUtil.assertEq((Configuration)expected, (Configuration)mc2);
    }

    public static String getTestFilename(String basename) {
        return System.getProperty("test.build.classes", "target/test-classes") + "/" + basename + ".properties";
    }
}

