/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.PlatformName;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Test;

public class TestUGIWithMiniKdc {
    private static MiniKdc kdc;

    @After
    public void teardown() {
        UserGroupInformation.reset();
        if (kdc != null) {
            kdc.stop();
        }
    }

    private void setupKdc() throws Exception {
        Properties kdcConf = MiniKdc.createConf();
        kdcConf.setProperty("max.ticket.lifetime", "30");
        kdcConf.setProperty("min.ticket.lifetime", "30");
        File kdcDir = new File(System.getProperty("test.dir", "target"));
        kdc = new MiniKdc(kdcConf, kdcDir);
        kdc.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testAutoRenewalThreadRetryWithKdc() throws Exception {
        GenericTestUtils.setLogLevel(UserGroupInformation.LOG, Level.DEBUG);
        Configuration conf = new Configuration();
        conf.setLong("hadoop.kerberos.min.seconds.before.relogin", 1L);
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        LoginContext loginContext = null;
        try {
            String principal = "foo";
            File workDir = new File(System.getProperty("test.dir", "target"));
            final File keytab = new File(workDir, "foo.keytab");
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal("foo"));
            this.setupKdc();
            kdc.createPrincipal(keytab, new String[]{"foo"});
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, new javax.security.auth.login.Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("principal", "foo");
                    options.put("refreshKrb5Config", "true");
                    if (PlatformName.IBM_JAVA) {
                        options.put("useKeytab", keytab.getPath());
                        options.put("credsType", "both");
                    } else {
                        options.put("keyTab", keytab.getPath());
                        options.put("useKeyTab", "true");
                        options.put("storeKey", "true");
                        options.put("doNotPrompt", "true");
                        options.put("useTicketCache", "true");
                        options.put("renewTGT", "true");
                        options.put("isInitiator", Boolean.toString(true));
                    }
                    String ticketCache = System.getenv("KRB5CCNAME");
                    if (ticketCache != null) {
                        options.put("ticketCache", ticketCache);
                    }
                    options.put("debug", "true");
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
                }
            });
            loginContext.login();
            Subject loginSubject = loginContext.getSubject();
            UserGroupInformation.loginUserFromSubject((Subject)loginSubject);
            LambdaTestUtils.await(30000, 500, () -> {
                int count = UserGroupInformation.metrics.getRenewalFailures().value();
                UserGroupInformation.LOG.info("Renew failure count is {}", (Object)count);
                return count > 0;
            });
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }
}

