/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.FindClass;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Test;

public class TestFindClass
extends Assert {
    private static final Log LOG = LogFactory.getLog(TestFindClass.class);
    public static final String LOG4J_PROPERTIES = "log4j.properties";

    private void run(int expected, String ... args) throws Exception {
        int result = ToolRunner.run((Tool)new FindClass(), (String[])args);
        TestFindClass.assertEquals((int)expected, (int)result);
    }

    @Test
    public void testUsage() throws Throwable {
        this.run(2, "org.apache.hadoop.util.TestFindClass");
    }

    @Test
    public void testFindsResource() throws Throwable {
        this.run(0, "locate", "org/apache/hadoop/util/TestFindClass.class");
    }

    @Test
    public void testFailsNoSuchResource() throws Throwable {
        this.run(3, "locate", "org/apache/hadoop/util/ThereIsNoSuchClass.class");
    }

    @Test
    public void testLoadFindsSelf() throws Throwable {
        this.run(0, "load", "org.apache.hadoop.util.TestFindClass");
    }

    @Test
    public void testLoadFailsNoSuchClass() throws Throwable {
        this.run(3, "load", "org.apache.hadoop.util.ThereIsNoSuchClass");
    }

    @Test
    public void testLoadWithErrorInStaticInit() throws Throwable {
        this.run(4, "load", "org.apache.hadoop.util.TestFindClass$FailInStaticInit");
    }

    @Test
    public void testCreateHandlesBadToString() throws Throwable {
        this.run(0, "create", "org.apache.hadoop.util.TestFindClass$BadToStringClass");
    }

    @Test
    public void testCreatesClass() throws Throwable {
        this.run(0, "create", "org.apache.hadoop.util.TestFindClass");
    }

    @Test
    public void testCreateFailsInStaticInit() throws Throwable {
        this.run(4, "create", "org.apache.hadoop.util.TestFindClass$FailInStaticInit");
    }

    @Test
    public void testCreateFailsInConstructor() throws Throwable {
        this.run(5, "create", "org.apache.hadoop.util.TestFindClass$FailInConstructor");
    }

    @Test
    public void testCreateFailsNoEmptyConstructor() throws Throwable {
        this.run(5, "create", "org.apache.hadoop.util.TestFindClass$NoEmptyConstructor");
    }

    @Test
    public void testLoadPrivateClass() throws Throwable {
        this.run(0, "load", "org.apache.hadoop.util.TestFindClass$PrivateClass");
    }

    @Test
    public void testCreateFailsPrivateClass() throws Throwable {
        this.run(5, "create", "org.apache.hadoop.util.TestFindClass$PrivateClass");
    }

    @Test
    public void testCreateFailsInPrivateConstructor() throws Throwable {
        this.run(5, "create", "org.apache.hadoop.util.TestFindClass$PrivateConstructor");
    }

    @Test
    public void testLoadFindsLog4J() throws Throwable {
        this.run(0, "locate", LOG4J_PROPERTIES);
    }

    @Test
    public void testPrintLog4J() throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        FindClass.setOutputStreams((PrintStream)out, (PrintStream)System.err);
        this.run(0, "print", LOG4J_PROPERTIES);
        out.flush();
        String body = baos.toString("UTF8");
        LOG.info((Object)("log4j.properties =\n" + body));
        TestFindClass.assertTrue((boolean)body.contains("Apache"));
    }

    public static class PrivateConstructor {
        private PrivateConstructor() {
        }
    }

    public static class PrivateClass {
        private PrivateClass() {
        }
    }

    public static class BadToStringClass {
        public String toString() {
            throw new NullPointerException("oops");
        }
    }

    public static class NoEmptyConstructor {
        public NoEmptyConstructor(String text) {
        }
    }

    public static class FailInConstructor {
        public FailInConstructor() {
            int x = 0;
            int y = 1 / x;
        }
    }

    public static class FailInStaticInit {
        static {
            int x = 0;
            int n = 1 / x;
        }
    }
}

