/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.IOException;
import java.io.InputStream;

public class ThrottledInputStream
extends InputStream {
    private final InputStream rawStream;
    private final long maxBytesPerSec;
    private final long startTime = System.currentTimeMillis();
    private long bytesRead = 0L;
    private long totalSleepTime = 0L;
    private static final long SLEEP_DURATION_MS = 50L;

    public ThrottledInputStream(InputStream rawStream) {
        this(rawStream, Long.MAX_VALUE);
    }

    public ThrottledInputStream(InputStream rawStream, long maxBytesPerSec) {
        assert (maxBytesPerSec > 0L) : "Bandwidth " + maxBytesPerSec + " is invalid";
        this.rawStream = rawStream;
        this.maxBytesPerSec = maxBytesPerSec;
    }

    @Override
    public int read() throws IOException {
        this.throttle();
        int data = this.rawStream.read();
        if (data != -1) {
            ++this.bytesRead;
        }
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.throttle();
        int readLen = this.rawStream.read(b);
        if (readLen != -1) {
            this.bytesRead += (long)readLen;
        }
        return readLen;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.throttle();
        int readLen = this.rawStream.read(b, off, len);
        if (readLen != -1) {
            this.bytesRead += (long)readLen;
        }
        return readLen;
    }

    private void throttle() throws IOException {
        if (this.getBytesPerSec() > this.maxBytesPerSec) {
            try {
                Thread.sleep(50L);
                this.totalSleepTime += 50L;
            }
            catch (InterruptedException e) {
                throw new IOException("Thread aborted", e);
            }
        }
    }

    public long getTotalBytesRead() {
        return this.bytesRead;
    }

    public long getBytesPerSec() {
        long elapsed = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (elapsed == 0L) {
            return this.bytesRead;
        }
        return this.bytesRead / elapsed;
    }

    public long getTotalSleepTime() {
        return this.totalSleepTime;
    }

    public String toString() {
        return "ThrottledInputStream{bytesRead=" + this.bytesRead + ", maxBytesPerSec=" + this.maxBytesPerSec + ", bytesPerSec=" + this.getBytesPerSec() + ", totalSleepTime=" + this.totalSleepTime + '}';
    }
}

