/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.TestDistCpWithAcls;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistCpWithAcls {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem fs;

    @BeforeClass
    public static void init() throws Exception {
        TestDistCpWithAcls.initCluster((boolean)true, (boolean)true);
        fs.mkdirs(new Path("/src/dir1/subdir1"));
        fs.mkdirs(new Path("/src/dir2"));
        fs.create(new Path("/src/dir2/file2")).close();
        fs.create(new Path("/src/dir2/file3")).close();
        fs.mkdirs(new Path("/src/dir3sticky"));
        fs.create(new Path("/src/file1")).close();
        fs.modifyAclEntries(new Path("/src/dir1"), Arrays.asList(TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.USER, (String)"bruce", (FsAction)FsAction.ALL)));
        fs.modifyAclEntries(new Path("/src/dir2/file2"), Arrays.asList(TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.GROUP, (String)"sales", (FsAction)FsAction.NONE)));
        fs.setPermission(new Path("/src/dir2/file3"), new FsPermission(432));
        fs.modifyAclEntries(new Path("/src/file1"), Arrays.asList(TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.USER, (String)"diana", (FsAction)FsAction.READ)));
        fs.setPermission(new Path("/src/dir3sticky"), new FsPermission(1023));
    }

    @AfterClass
    public static void shutdown() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testPreserveAcls() throws Exception {
        TestDistCpWithAcls.assertRunDistCp((int)0, (String)"/dstPreserveAcls");
        TestDistCpWithAcls.assertAclEntries((String)"/dstPreserveAcls/dir1", (AclEntry[])new AclEntry[]{TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.USER, (FsAction)FsAction.ALL), TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.USER, (String)"bruce", (FsAction)FsAction.ALL), TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.GROUP, (FsAction)FsAction.READ_EXECUTE), TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.MASK, (FsAction)FsAction.ALL), TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.OTHER, (FsAction)FsAction.READ_EXECUTE)});
        TestDistCpWithAcls.assertPermission((String)"/dstPreserveAcls/dir1", (short)493);
        TestDistCpWithAcls.assertAclEntries((String)"/dstPreserveAcls/dir1/subdir1", (AclEntry[])new AclEntry[0]);
        TestDistCpWithAcls.assertPermission((String)"/dstPreserveAcls/dir1/subdir1", (short)493);
        TestDistCpWithAcls.assertAclEntries((String)"/dstPreserveAcls/dir2", (AclEntry[])new AclEntry[0]);
        TestDistCpWithAcls.assertPermission((String)"/dstPreserveAcls/dir2", (short)493);
        TestDistCpWithAcls.assertAclEntries((String)"/dstPreserveAcls/dir2/file2", (AclEntry[])new AclEntry[]{TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.GROUP, (FsAction)FsAction.READ), TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.GROUP, (String)"sales", (FsAction)FsAction.NONE)});
        TestDistCpWithAcls.assertPermission((String)"/dstPreserveAcls/dir2/file2", (short)420);
        TestDistCpWithAcls.assertAclEntries((String)"/dstPreserveAcls/dir2/file3", (AclEntry[])new AclEntry[0]);
        TestDistCpWithAcls.assertPermission((String)"/dstPreserveAcls/dir2/file3", (short)432);
        TestDistCpWithAcls.assertAclEntries((String)"/dstPreserveAcls/dir3sticky", (AclEntry[])new AclEntry[0]);
        TestDistCpWithAcls.assertPermission((String)"/dstPreserveAcls/dir3sticky", (short)1023);
        TestDistCpWithAcls.assertAclEntries((String)"/dstPreserveAcls/file1", (AclEntry[])new AclEntry[]{TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.USER, (String)"diana", (FsAction)FsAction.READ), TestDistCpWithAcls.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.GROUP, (FsAction)FsAction.READ)});
        TestDistCpWithAcls.assertPermission((String)"/dstPreserveAcls/file1", (short)420);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAclsNotEnabled() throws Exception {
        try {
            TestDistCpWithAcls.restart((boolean)false);
            TestDistCpWithAcls.assertRunDistCp((int)-3, (String)"/dstAclsNotEnabled");
        }
        finally {
            TestDistCpWithAcls.restart((boolean)true);
        }
    }

    @Test
    public void testAclsNotImplemented() throws Exception {
        TestDistCpWithAcls.assertRunDistCp((int)-3, (String)"stubfs://dstAclsNotImplemented");
    }

    private static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setPermission(permission).build();
    }

    private static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, String name, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setName(name).setPermission(permission).build();
    }

    private static void assertAclEntries(String path, AclEntry[] entries) throws Exception {
        Assert.assertArrayEquals((Object[])entries, (Object[])fs.getAclStatus(new Path(path)).getEntries().toArray(new AclEntry[0]));
    }

    private static void assertPermission(String path, short perm) throws Exception {
        Assert.assertEquals((long)perm, (long)fs.getFileStatus(new Path(path)).getPermission().toShort());
    }

    private static void assertRunDistCp(int exitCode, String dst) throws Exception {
        DistCp distCp = new DistCp(conf, null);
        Assert.assertEquals((long)exitCode, (long)ToolRunner.run((Configuration)conf, (Tool)distCp, (String[])new String[]{"-pa", "/src", dst}));
    }

    private static void initCluster(boolean format, boolean aclsEnabled) throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.acls.enabled", aclsEnabled);
        conf.set("fs.defaultFS", "stubfs:///");
        conf.setClass("fs.stubfs.impl", StubFileSystem.class, FileSystem.class);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    private static void restart(boolean aclsEnabled) throws Exception {
        TestDistCpWithAcls.shutdown();
        TestDistCpWithAcls.initCluster((boolean)false, (boolean)aclsEnabled);
    }
}

