/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.tools.mapred.CopyCommitter;
import org.apache.hadoop.tools.mapred.CopyOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestCopyOutputFormat {
    private static final Log LOG = LogFactory.getLog(TestCopyOutputFormat.class);

    @Test
    public void testSetCommitDirectory() {
        try {
            Job job = Job.getInstance((Configuration)new Configuration());
            Assert.assertEquals(null, (Object)CopyOutputFormat.getCommitDirectory((Job)job));
            job.getConfiguration().set("distcp.target.final.path", "");
            Assert.assertEquals(null, (Object)CopyOutputFormat.getCommitDirectory((Job)job));
            Path directory = new Path("/tmp/test");
            CopyOutputFormat.setCommitDirectory((Job)job, (Path)directory);
            Assert.assertEquals((Object)directory, (Object)CopyOutputFormat.getCommitDirectory((Job)job));
            Assert.assertEquals((Object)directory.toString(), (Object)job.getConfiguration().get("distcp.target.final.path"));
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running test", (Throwable)e);
            Assert.fail((String)"Failed while testing for set Commit Directory");
        }
    }

    @Test
    public void testSetWorkingDirectory() {
        try {
            Job job = Job.getInstance((Configuration)new Configuration());
            Assert.assertEquals(null, (Object)CopyOutputFormat.getWorkingDirectory((Job)job));
            job.getConfiguration().set("distcp.target.work.path", "");
            Assert.assertEquals(null, (Object)CopyOutputFormat.getWorkingDirectory((Job)job));
            Path directory = new Path("/tmp/test");
            CopyOutputFormat.setWorkingDirectory((Job)job, (Path)directory);
            Assert.assertEquals((Object)directory, (Object)CopyOutputFormat.getWorkingDirectory((Job)job));
            Assert.assertEquals((Object)directory.toString(), (Object)job.getConfiguration().get("distcp.target.work.path"));
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running test", (Throwable)e);
            Assert.fail((String)"Failed while testing for set Working Directory");
        }
    }

    @Test
    public void testGetOutputCommitter() {
        try {
            TaskAttemptContextImpl context = new TaskAttemptContextImpl(new Configuration(), new TaskAttemptID("200707121733", 1, TaskType.MAP, 1, 1));
            context.getConfiguration().set("mapred.output.dir", "/out");
            Assert.assertTrue((boolean)(new CopyOutputFormat().getOutputCommitter((TaskAttemptContext)context) instanceof CopyCommitter));
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)"Unable to get output committer");
        }
    }

    @Test
    public void testCheckOutputSpecs() {
        try {
            JobContextImpl context;
            CopyOutputFormat outputFormat = new CopyOutputFormat();
            Job job = Job.getInstance((Configuration)new Configuration());
            JobID jobID = new JobID("200707121733", 1);
            try {
                context = new JobContextImpl(job.getConfiguration(), jobID);
                outputFormat.checkOutputSpecs((JobContext)context);
                Assert.fail((String)"No checking for invalid work/commit path");
            }
            catch (IllegalStateException ignore) {
                // empty catch block
            }
            CopyOutputFormat.setWorkingDirectory((Job)job, (Path)new Path("/tmp/work"));
            try {
                context = new JobContextImpl(job.getConfiguration(), jobID);
                outputFormat.checkOutputSpecs((JobContext)context);
                Assert.fail((String)"No checking for invalid commit path");
            }
            catch (IllegalStateException ignore) {
                // empty catch block
            }
            job.getConfiguration().set("distcp.target.work.path", "");
            CopyOutputFormat.setCommitDirectory((Job)job, (Path)new Path("/tmp/commit"));
            try {
                context = new JobContextImpl(job.getConfiguration(), jobID);
                outputFormat.checkOutputSpecs((JobContext)context);
                Assert.fail((String)"No checking for invalid work path");
            }
            catch (IllegalStateException ignore) {
                // empty catch block
            }
            CopyOutputFormat.setWorkingDirectory((Job)job, (Path)new Path("/tmp/work"));
            CopyOutputFormat.setCommitDirectory((Job)job, (Path)new Path("/tmp/commit"));
            try {
                context = new JobContextImpl(job.getConfiguration(), jobID);
                outputFormat.checkOutputSpecs((JobContext)context);
            }
            catch (IllegalStateException ignore) {
                Assert.fail((String)"Output spec check failed.");
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing checkoutput specs", (Throwable)e);
            Assert.fail((String)"Checkoutput Spec failure");
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception encountered while testing checkoutput specs", (Throwable)e);
            Assert.fail((String)"Checkoutput Spec failure");
        }
    }
}

