/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;

public class DistCpTestUtils {
    public static void assertXAttrs(Path path, FileSystem fs, Map<String, byte[]> expectedXAttrs) throws Exception {
        Map xAttrs = fs.getXAttrs(path);
        Assert.assertEquals((String)path.toString(), (long)expectedXAttrs.size(), (long)xAttrs.size());
        for (Map.Entry<String, byte[]> e : expectedXAttrs.entrySet()) {
            String name = e.getKey();
            byte[] value = e.getValue();
            if (value == null) {
                Assert.assertTrue((xAttrs.containsKey(name) && xAttrs.get(name) == null ? 1 : 0) != 0);
                continue;
            }
            Assert.assertArrayEquals((byte[])value, (byte[])((byte[])xAttrs.get(name)));
        }
    }

    public static void assertRunDistCp(int exitCode, String src, String dst, String options, Configuration conf) throws Exception {
        String[] stringArray;
        DistCp distCp = new DistCp(conf, null);
        if (options == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = src;
            stringArray = stringArray2;
            stringArray2[1] = dst;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = options;
            stringArray3[1] = src;
            stringArray = stringArray3;
            stringArray3[2] = dst;
        }
        String[] optsArr = stringArray;
        Assert.assertEquals((long)exitCode, (long)ToolRunner.run((Configuration)conf, (Tool)distCp, (String[])optsArr));
    }
}

