/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.Collections;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.junit.Assert;
import org.junit.Test;

public class TestDistCpOptions {
    private static final float DELTA = 0.001f;

    @Test
    public void testSetIgnoreFailure() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)builder.build().shouldIgnoreFailures());
        builder.withIgnoreFailures(true);
        Assert.assertTrue((boolean)builder.build().shouldIgnoreFailures());
    }

    @Test
    public void testSetOverwrite() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)builder.build().shouldOverwrite());
        builder.withOverwrite(true);
        Assert.assertTrue((boolean)builder.build().shouldOverwrite());
        try {
            builder.withSyncFolder(true).build();
            Assert.fail((String)"Update and overwrite aren't allowed together");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLogPath() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertNull((Object)builder.build().getLogPath());
        Path logPath = new Path("hdfs://localhost:8020/logs");
        builder.withLogPath(logPath);
        Assert.assertEquals((Object)logPath, (Object)builder.build().getLogPath());
    }

    @Test
    public void testSetBlokcing() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertTrue((boolean)builder.build().shouldBlock());
        builder.withBlocking(false);
        Assert.assertFalse((boolean)builder.build().shouldBlock());
    }

    @Test
    public void testSetBandwidth() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((float)0.0f, (float)builder.build().getMapBandwidth(), (float)0.001f);
        builder.withMapBandwidth(11.0f);
        Assert.assertEquals((float)11.0f, (float)builder.build().getMapBandwidth(), (float)0.001f);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNonPositiveBandwidth() {
        new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withMapBandwidth(-11.0f).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetZeroBandwidth() {
        new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withMapBandwidth(0.0f).build();
    }

    @Test
    public void testSetSkipCRC() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)builder.build().shouldSkipCRC());
        DistCpOptions options = builder.withSyncFolder(true).withCRC(true).build();
        Assert.assertTrue((boolean)options.shouldSyncFolder());
        Assert.assertTrue((boolean)options.shouldSkipCRC());
    }

    @Test
    public void testSetAtomicCommit() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)builder.build().shouldAtomicCommit());
        builder.withAtomicCommit(true);
        Assert.assertTrue((boolean)builder.build().shouldAtomicCommit());
        try {
            builder.withSyncFolder(true).build();
            Assert.fail((String)"Atomic and sync folders were mutually exclusive");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetWorkPath() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertNull((Object)builder.build().getAtomicWorkPath());
        builder.withAtomicCommit(true);
        Assert.assertNull((Object)builder.build().getAtomicWorkPath());
        Path workPath = new Path("hdfs://localhost:8020/work");
        builder.withAtomicWorkPath(workPath);
        Assert.assertEquals((Object)workPath, (Object)builder.build().getAtomicWorkPath());
    }

    @Test
    public void testSetSyncFolders() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)builder.build().shouldSyncFolder());
        builder.withSyncFolder(true);
        Assert.assertTrue((boolean)builder.build().shouldSyncFolder());
    }

    @Test
    public void testSetDeleteMissing() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)builder.build().shouldDeleteMissing());
        DistCpOptions options = builder.withSyncFolder(true).withDeleteMissing(true).build();
        Assert.assertTrue((boolean)options.shouldSyncFolder());
        Assert.assertTrue((boolean)options.shouldDeleteMissing());
        options = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withOverwrite(true).withDeleteMissing(true).build();
        Assert.assertTrue((boolean)options.shouldOverwrite());
        Assert.assertTrue((boolean)options.shouldDeleteMissing());
        try {
            new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withDeleteMissing(true).build();
            Assert.fail((String)"Delete missing should fail without update or overwrite options");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Delete missing is applicable only with update or overwrite options", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withDeleteMissing(true).withUseDiff("s1", "s2").build();
            Assert.fail((String)"Should have failed as -delete and -diff are mutually exclusive.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive.", (Throwable)e);
        }
    }

    @Test
    public void testSetMaps() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((long)20L, (long)builder.build().getMaxMaps());
        builder.maxMaps(1);
        Assert.assertEquals((long)1L, (long)builder.build().getMaxMaps());
        builder.maxMaps(0);
        Assert.assertEquals((long)1L, (long)builder.build().getMaxMaps());
    }

    @Test
    public void testSetNumListtatusThreads() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((long)0L, (long)builder.build().getNumListstatusThreads());
        builder.withNumListstatusThreads(12);
        Assert.assertEquals((long)12L, (long)builder.build().getNumListstatusThreads());
        builder.withNumListstatusThreads(0);
        Assert.assertEquals((long)0L, (long)builder.build().getNumListstatusThreads());
        builder.withNumListstatusThreads(80);
        Assert.assertEquals((long)40L, (long)builder.build().getNumListstatusThreads());
    }

    @Test
    public void testSourceListing() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((Object)new Path("hdfs://localhost:8020/source/first"), (Object)builder.build().getSourceFileListing());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingTarget() {
        new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), null);
    }

    @Test
    public void testToString() {
        DistCpOptions option = new DistCpOptions.Builder(new Path("abc"), new Path("xyz")).build();
        String val = "DistCpOptions{atomicCommit=false, syncFolder=false, deleteMissing=false, ignoreFailures=false, overwrite=false, append=false, useDiff=false, useRdiff=false, fromSnapshot=null, toSnapshot=null, skipCRC=false, blocking=true, numListstatusThreads=0, maxMaps=20, mapBandwidth=0.0, copyStrategy='uniformsize', preserveStatus=[], atomicWorkPath=null, logPath=null, sourceFileListing=abc, sourcePaths=null, targetPath=xyz, filtersFile='null', blocksPerChunk=0, copyBufferSize=8192, verboseLog=false}";
        String optionString = option.toString();
        Assert.assertEquals((Object)val, (Object)optionString);
        Assert.assertNotSame((Object)DistCpOptionSwitch.ATOMIC_COMMIT.toString(), (Object)DistCpOptionSwitch.ATOMIC_COMMIT.name());
    }

    @Test
    public void testCopyStrategy() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((Object)"uniformsize", (Object)builder.build().getCopyStrategy());
        builder.withCopyStrategy("dynamic");
        Assert.assertEquals((Object)"dynamic", (Object)builder.build().getCopyStrategy());
    }

    @Test
    public void testTargetPath() {
        DistCpOptions options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).build();
        Assert.assertEquals((Object)new Path("hdfs://localhost:8020/target/"), (Object)options.getTargetPath());
    }

    @Test
    public void testPreserve() {
        DistCpOptions options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).build();
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).preserve(DistCpOptions.FileAttribute.ACL).build();
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).preserve(DistCpOptions.FileAttribute.BLOCKSIZE).preserve(DistCpOptions.FileAttribute.REPLICATION).preserve(DistCpOptions.FileAttribute.PERMISSION).preserve(DistCpOptions.FileAttribute.USER).preserve(DistCpOptions.FileAttribute.GROUP).preserve(DistCpOptions.FileAttribute.CHECKSUMTYPE).build();
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
    }

    @Test
    public void testAppendOption() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withAppend(true);
        Assert.assertTrue((boolean)builder.build().shouldAppend());
        try {
            new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withAppend(true).build();
            Assert.fail((String)"Append should fail if update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is valid only with update options", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withAppend(true).withCRC(true).build();
            Assert.fail((String)"Append should fail if skipCrc option is specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is disallowed when skipping CRC", (Throwable)e);
        }
    }

    @Test
    public void testDiffOption() {
        DistCpOptions options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withUseDiff("s1", "s2").build();
        Assert.assertTrue((boolean)options.shouldUseDiff());
        Assert.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        Assert.assertEquals((Object)"s2", (Object)options.getToSnapshot());
        options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withUseDiff("s1", ".").build();
        Assert.assertTrue((boolean)options.shouldUseDiff());
        Assert.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        Assert.assertEquals((Object)".", (Object)options.getToSnapshot());
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withUseDiff("s1", "s2").build();
            Assert.fail((String)"-diff should fail if -update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff/-rdiff is valid only with -update option", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withUseDiff("s1", "s2").withDeleteMissing(true).build();
            Assert.fail((String)"Should fail as -delete and -diff/-rdiff are mutually exclusive.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive.", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withUseDiff("s1", "s2").withDeleteMissing(true).build();
            Assert.fail((String)"-diff should fail if -update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive.", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withDeleteMissing(true).withUseDiff("s1", "s2").build();
            Assert.fail((String)"Should have failed as -delete and -diff are mutually exclusive");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive", (Throwable)e);
        }
    }

    @Test
    public void testExclusionsOption() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assert.assertNull((Object)builder.build().getFiltersFile());
        builder.withFiltersFile("/tmp/filters.txt");
        Assert.assertEquals((Object)"/tmp/filters.txt", (Object)builder.build().getFiltersFile());
    }

    @Test
    public void testSetOptionsForSplitLargeFile() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/"), new Path("hdfs://localhost:8020/target/")).withAppend(true).withSyncFolder(true);
        Assert.assertFalse((boolean)builder.build().shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)builder.build().shouldAppend());
        builder.withBlocksPerChunk(5440);
        Assert.assertTrue((boolean)builder.build().shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)builder.build().shouldAppend());
    }

    @Test
    public void testSetCopyBufferSize() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertEquals((long)8192L, (long)builder.build().getCopyBufferSize());
        builder.withCopyBufferSize(0x400000);
        Assert.assertEquals((long)0x400000L, (long)builder.build().getCopyBufferSize());
        builder.withCopyBufferSize(-1);
        Assert.assertEquals((long)8192L, (long)builder.build().getCopyBufferSize());
    }

    @Test
    public void testVerboseLog() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assert.assertFalse((boolean)builder.build().shouldVerboseLog());
        try {
            builder.withVerboseLog(true).build();
            Assert.fail((String)"-v should fail if -log option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-v is valid only with -log option", (Throwable)e);
        }
        Path logPath = new Path("hdfs://localhost:8020/logs");
        builder.withLogPath(logPath).withVerboseLog(true);
        Assert.assertTrue((boolean)builder.build().shouldVerboseLog());
    }
}

