/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred.lib;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.StubContext;
import org.apache.hadoop.tools.mapred.lib.DynamicInputChunkContext;
import org.apache.hadoop.tools.mapred.lib.DynamicInputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDynamicInputFormat {
    private static final Log LOG = LogFactory.getLog(TestDynamicInputFormat.class);
    private static MiniDFSCluster cluster;
    private static final int N_FILES = 1000;
    private static final int NUM_SPLITS = 7;
    private static final Credentials CREDENTIALS;
    private static List<String> expectedFilePaths;

    @BeforeClass
    public static void setup() throws Exception {
        cluster = new MiniDFSCluster.Builder(TestDynamicInputFormat.getConfigurationForCluster()).numDataNodes(1).format(true).build();
        for (int i = 0; i < 1000; ++i) {
            TestDynamicInputFormat.createFile("/tmp/source/" + String.valueOf(i));
        }
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        expectedFilePaths.add(fileSystem.listStatus(new Path("/tmp/source/0"))[0].getPath().getParent().toString());
    }

    private static Configuration getConfigurationForCluster() {
        Configuration configuration = new Configuration();
        System.setProperty("test.build.data", "target/tmp/build/TEST_DYNAMIC_INPUT_FORMAT/data");
        configuration.set("hadoop.log.dir", "target/tmp");
        LOG.debug((Object)("fs.default.name  == " + configuration.get("fs.default.name")));
        LOG.debug((Object)("dfs.http.address == " + configuration.get("dfs.http.address")));
        return configuration;
    }

    private static DistCpOptions getOptions() throws Exception {
        Path sourcePath = new Path(cluster.getFileSystem().getUri().toString() + "/tmp/source");
        Path targetPath = new Path(cluster.getFileSystem().getUri().toString() + "/tmp/target");
        ArrayList<Path> sourceList = new ArrayList<Path>();
        sourceList.add(sourcePath);
        return new DistCpOptions.Builder(sourceList, targetPath).maxMaps(7).build();
    }

    private static void createFile(String path) throws Exception {
        DistributedFileSystem fileSystem = null;
        FSDataOutputStream outputStream = null;
        try {
            fileSystem = cluster.getFileSystem();
            outputStream = fileSystem.create(new Path(path), true, 0);
            expectedFilePaths.add(fileSystem.listStatus(new Path(path))[0].getPath().toString());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    @Test
    public void testGetSplits() throws Exception {
        DistCpContext context = new DistCpContext(TestDynamicInputFormat.getOptions());
        Configuration configuration = new Configuration();
        configuration.set("mapred.map.tasks", String.valueOf(context.getMaxMaps()));
        CopyListing.getCopyListing((Configuration)configuration, (Credentials)CREDENTIALS, (DistCpContext)context).buildListing(new Path(cluster.getFileSystem().getUri().toString() + "/tmp/testDynInputFormat/fileList.seq"), context);
        JobContextImpl jobContext = new JobContextImpl(configuration, new JobID());
        DynamicInputFormat inputFormat = new DynamicInputFormat();
        List splits = inputFormat.getSplits((JobContext)jobContext);
        int nFiles = 0;
        int taskId = 0;
        for (InputSplit split : splits) {
            StubContext stubContext = new StubContext(jobContext.getConfiguration(), null, taskId);
            Mapper.Context taskAttemptContext = stubContext.getContext();
            RecordReader recordReader = inputFormat.createRecordReader(split, (TaskAttemptContext)taskAttemptContext);
            stubContext.setReader((RecordReader<Text, CopyListingFileStatus>)recordReader);
            recordReader.initialize((InputSplit)splits.get(0), (TaskAttemptContext)taskAttemptContext);
            float previousProgressValue = 0.0f;
            while (recordReader.nextKeyValue()) {
                CopyListingFileStatus fileStatus = (CopyListingFileStatus)recordReader.getCurrentValue();
                String source = fileStatus.getPath().toString();
                System.out.println(source);
                Assert.assertTrue((boolean)expectedFilePaths.contains(source));
                float progress = recordReader.getProgress();
                Assert.assertTrue((progress >= previousProgressValue ? 1 : 0) != 0);
                Assert.assertTrue((progress >= 0.0f ? 1 : 0) != 0);
                Assert.assertTrue((progress <= 1.0f ? 1 : 0) != 0);
                previousProgressValue = progress;
                ++nFiles;
            }
            Assert.assertTrue((recordReader.getProgress() == 1.0f ? 1 : 0) != 0);
            ++taskId;
        }
        Assert.assertEquals((long)expectedFilePaths.size(), (long)nFiles);
    }

    @Test
    public void testGetSplitRatio() throws Exception {
        Assert.assertEquals((long)1L, (long)DynamicInputFormat.getSplitRatio((int)1, (int)1000000000));
        Assert.assertEquals((long)2L, (long)DynamicInputFormat.getSplitRatio((int)11000000, (int)10));
        Assert.assertEquals((long)4L, (long)DynamicInputFormat.getSplitRatio((int)30, (int)700));
        Assert.assertEquals((long)2L, (long)DynamicInputFormat.getSplitRatio((int)30, (int)200));
        Configuration conf = new Configuration();
        conf.setInt("distcp.dynamic.max.chunks.tolerable", -1);
        conf.setInt("distcp.dynamic.max.chunks.ideal", -1);
        conf.setInt("distcp.dynamic.min.records_per_chunk", -1);
        conf.setInt("distcp.dynamic.split.ratio", -1);
        Assert.assertEquals((long)1L, (long)DynamicInputFormat.getSplitRatio((int)1, (int)1000000000, (Configuration)conf));
        Assert.assertEquals((long)2L, (long)DynamicInputFormat.getSplitRatio((int)11000000, (int)10, (Configuration)conf));
        Assert.assertEquals((long)4L, (long)DynamicInputFormat.getSplitRatio((int)30, (int)700, (Configuration)conf));
        Assert.assertEquals((long)2L, (long)DynamicInputFormat.getSplitRatio((int)30, (int)200, (Configuration)conf));
        conf.setInt("distcp.dynamic.max.chunks.tolerable", 100);
        conf.setInt("distcp.dynamic.max.chunks.ideal", 30);
        conf.setInt("distcp.dynamic.min.records_per_chunk", 10);
        conf.setInt("distcp.dynamic.split.ratio", 53);
        Assert.assertEquals((long)53L, (long)DynamicInputFormat.getSplitRatio((int)3, (int)200, (Configuration)conf));
    }

    @Test
    public void testDynamicInputChunkContext() throws IOException {
        Configuration configuration = new Configuration();
        configuration.set("distcp.listing.file.path", "/tmp/test/file1.seq");
        DynamicInputFormat firstInputFormat = new DynamicInputFormat();
        DynamicInputFormat secondInputFormat = new DynamicInputFormat();
        DynamicInputChunkContext firstContext = firstInputFormat.getChunkContext(configuration);
        DynamicInputChunkContext secondContext = firstInputFormat.getChunkContext(configuration);
        DynamicInputChunkContext thirdContext = secondInputFormat.getChunkContext(configuration);
        DynamicInputChunkContext fourthContext = secondInputFormat.getChunkContext(configuration);
        Assert.assertTrue((String)"Chunk contexts from the same DynamicInputFormat object should be the same.", (boolean)firstContext.equals(secondContext));
        Assert.assertTrue((String)"Chunk contexts from the same DynamicInputFormat object should be the same.", (boolean)thirdContext.equals(fourthContext));
        Assert.assertTrue((String)"Contexts from different DynamicInputFormat objects should be different.", (!firstContext.equals(thirdContext) ? 1 : 0) != 0);
    }

    static {
        CREDENTIALS = new Credentials();
        expectedFilePaths = new ArrayList<String>(1000);
    }
}

