/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistCpViewFs {
    private static final Logger LOG = LoggerFactory.getLogger(TestDistCpViewFs.class);
    private static FileSystem fs;
    private static Path listFile;
    private static Path target;
    private static String root;

    private static Configuration getConf() throws URISyntaxException {
        Configuration conf = new Configuration();
        conf.set("mapred.job.tracker", "local");
        conf.set("fs.default.name", "file:///");
        return conf;
    }

    @BeforeClass
    public static void setup() throws URISyntaxException {
        try {
            Path fswd = FileSystem.get((Configuration)TestDistCpViewFs.getConf()).getWorkingDirectory();
            Configuration vConf = ViewFileSystemTestSetup.createConfig((boolean)false);
            ConfigUtil.addLink((Configuration)vConf, (String)"/usr", (URI)new URI(fswd.toString()));
            fs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)vConf);
            fs.setWorkingDirectory(new Path("/usr"));
            listFile = new Path("target/tmp/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            target = new Path("target/tmp/target").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            root = new Path("target/tmp").makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            TestDistCpUtils.delete(fs, root);
        }
        catch (IOException e) {
            LOG.error("Exception encountered ", (Throwable)e);
        }
    }

    @Test
    public void testSingleFileMissingTarget() throws IOException {
        this.caseSingleFileMissingTarget(false);
        this.caseSingleFileMissingTarget(true);
    }

    private void caseSingleFileMissingTarget(boolean sync) throws IOException {
        try {
            this.addEntries(listFile, "singlefile1/file1");
            this.createFiles("singlefile1/file1");
            this.runTest(listFile, target, false, sync);
            this.checkResult(target, 1, new String[0]);
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testSingleFileTargetFile() throws IOException {
        this.caseSingleFileTargetFile(false);
        this.caseSingleFileTargetFile(true);
    }

    private void caseSingleFileTargetFile(boolean sync) throws IOException {
        try {
            this.addEntries(listFile, "singlefile1/file1");
            this.createFiles("singlefile1/file1", target.toString());
            this.runTest(listFile, target, false, sync);
            this.checkResult(target, 1, new String[0]);
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testSingleFileTargetDir() throws IOException {
        this.caseSingleFileTargetDir(false);
        this.caseSingleFileTargetDir(true);
    }

    private void caseSingleFileTargetDir(boolean sync) throws IOException {
        try {
            this.addEntries(listFile, "singlefile2/file2");
            this.createFiles("singlefile2/file2");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true, sync);
            this.checkResult(target, 1, "file2");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testSingleDirTargetMissing() throws IOException {
        this.caseSingleDirTargetMissing(false);
        this.caseSingleDirTargetMissing(true);
    }

    private void caseSingleDirTargetMissing(boolean sync) throws IOException {
        try {
            this.addEntries(listFile, "singledir");
            this.mkdirs(root + "/singledir/dir1");
            this.runTest(listFile, target, false, sync);
            this.checkResult(target, 1, "dir1");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testSingleDirTargetPresent() throws IOException {
        try {
            this.addEntries(listFile, "singledir");
            this.mkdirs(root + "/singledir/dir1");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true, false);
            this.checkResult(target, 1, "singledir/dir1");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testUpdateSingleDirTargetPresent() throws IOException {
        try {
            this.addEntries(listFile, "Usingledir");
            this.mkdirs(root + "/Usingledir/Udir1");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true, true);
            this.checkResult(target, 1, "Udir1");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testMultiFileTargetPresent() throws IOException {
        this.caseMultiFileTargetPresent(false);
        this.caseMultiFileTargetPresent(true);
    }

    private void caseMultiFileTargetPresent(boolean sync) throws IOException {
        try {
            this.addEntries(listFile, "multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true, sync);
            this.checkResult(target, 3, "file3", "file4", "file5");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testMultiFileTargetMissing() throws IOException {
        this.caseMultiFileTargetMissing(false);
        this.caseMultiFileTargetMissing(true);
    }

    private void caseMultiFileTargetMissing(boolean sync) throws IOException {
        try {
            this.addEntries(listFile, "multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.runTest(listFile, target, false, sync);
            this.checkResult(target, 3, "file3", "file4", "file5");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testMultiDirTargetPresent() throws IOException {
        try {
            this.addEntries(listFile, "multifile", "singledir");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.mkdirs(target.toString(), root + "/singledir/dir1");
            this.runTest(listFile, target, true, false);
            this.checkResult(target, 2, "multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir1");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testUpdateMultiDirTargetPresent() throws IOException {
        try {
            this.addEntries(listFile, "Umultifile", "Usingledir");
            this.createFiles("Umultifile/Ufile3", "Umultifile/Ufile4", "Umultifile/Ufile5");
            this.mkdirs(target.toString(), root + "/Usingledir/Udir1");
            this.runTest(listFile, target, true, true);
            this.checkResult(target, 4, "Ufile3", "Ufile4", "Ufile5", "Udir1");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testMultiDirTargetMissing() throws IOException {
        try {
            this.addEntries(listFile, "multifile", "singledir");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.mkdirs(root + "/singledir/dir1");
            this.runTest(listFile, target, false, false);
            this.checkResult(target, 2, "multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir1");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testUpdateMultiDirTargetMissing() throws IOException {
        try {
            this.addEntries(listFile, "multifile", "singledir");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.mkdirs(root + "/singledir/dir1");
            this.runTest(listFile, target, false, true);
            this.checkResult(target, 4, "file3", "file4", "file5", "dir1");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test
    public void testGlobTargetMissingSingleLevel() throws IOException {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, "*");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("singledir/dir2/file6");
            this.runTest(listFile, target, false, false);
            this.checkResult(target, 2, "multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir2/file6");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    @Test
    public void testUpdateGlobTargetMissingSingleLevel() throws IOException {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, "*");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("singledir/dir2/file6");
            this.runTest(listFile, target, false, true);
            this.checkResult(target, 4, "file3", "file4", "file5", "dir2/file6");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    @Test
    public void testGlobTargetMissingMultiLevel() throws IOException {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, "*/*");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("singledir1/dir3/file7", "singledir1/dir3/file8", "singledir1/dir3/file9");
            this.runTest(listFile, target, false, false);
            this.checkResult(target, 4, "file3", "file4", "file5", "dir3/file7", "dir3/file8", "dir3/file9");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    @Test
    public void testUpdateGlobTargetMissingMultiLevel() throws IOException {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, "*/*");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("singledir1/dir3/file7", "singledir1/dir3/file8", "singledir1/dir3/file9");
            this.runTest(listFile, target, false, true);
            this.checkResult(target, 6, "file3", "file4", "file5", "file7", "file8", "file9");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntries(Path listFile, String ... entries) throws IOException {
        try (FSDataOutputStream out = fs.create(listFile);){
            for (String entry : entries) {
                out.write((root + "/" + entry).getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(String ... entries) throws IOException {
        for (String entry : entries) {
            String e = new Path(entry).isAbsolute() ? entry : root + "/" + entry;
            try (FSDataOutputStream out = fs.create(new Path(e));){
                out.write(e.getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    private void mkdirs(String ... entries) throws IOException {
        for (String entry : entries) {
            fs.mkdirs(new Path(entry));
        }
    }

    private void runTest(Path listFile, Path target, boolean targetExists, boolean sync) throws IOException {
        DistCpOptions options = new DistCpOptions.Builder(listFile, target).withSyncFolder(sync).build();
        try {
            DistCp distcp = new DistCp(TestDistCpViewFs.getConf(), options);
            distcp.context.setTargetPathExists(targetExists);
            distcp.execute();
        }
        catch (Exception e) {
            LOG.error("Exception encountered ", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void checkResult(Path target, int count, String ... relPaths) throws IOException {
        Assert.assertEquals((long)count, (long)fs.listStatus(target).length);
        if (relPaths == null || relPaths.length == 0) {
            Assert.assertTrue((String)target.toString(), (boolean)fs.exists(target));
            return;
        }
        for (String relPath : relPaths) {
            Assert.assertTrue((String)new Path(target, relPath).toString(), (boolean)fs.exists(new Path(target, relPath)));
        }
    }
}

