/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.mapred.gridmix.RandomAlgorithms;
import org.junit.Assert;
import org.junit.Test;

public class TestRandomAlgorithm {
    private static final int[][] parameters = new int[][]{{5, 1, 1}, {10, 1, 2}, {10, 2, 2}, {20, 1, 3}, {20, 2, 3}, {20, 3, 3}, {100, 3, 10}, {100, 3, 100}, {100, 3, 1000}, {100, 3, 10000}, {100, 3, 100000}, {100, 3, 1000000}};

    private List<Integer> convertIntArray(int[] from) {
        ArrayList<Integer> ret = new ArrayList<Integer>(from.length);
        for (int v : from) {
            ret.add(v);
        }
        return ret;
    }

    private void testRandomSelectSelector(int niter, int m, int n) {
        RandomAlgorithms.Selector selector = new RandomAlgorithms.Selector(n, (double)m / (double)n, new Random());
        HashMap<List, Integer> results = new HashMap<List, Integer>(niter);
        for (int i = 0; i < niter; ++i) {
            int v;
            int[] result = new int[m];
            for (int j = 0; j < m && (v = selector.next()) >= 0; ++j) {
                result[j] = v;
            }
            Arrays.sort(result);
            List resultAsList = this.convertIntArray(result);
            Integer count = (Integer)results.get(resultAsList);
            if (count == null) {
                results.put(resultAsList, 1);
            } else {
                count = count + 1;
                results.put(resultAsList, count);
            }
            selector.reset();
        }
        this.verifyResults(results, m, n);
    }

    private void testRandomSelect(int niter, int m, int n) {
        Random random = new Random();
        HashMap<List, Integer> results = new HashMap<List, Integer>(niter);
        for (int i = 0; i < niter; ++i) {
            int[] result = RandomAlgorithms.select((int)m, (int)n, (Random)random);
            Arrays.sort(result);
            List resultAsList = this.convertIntArray(result);
            Integer count = (Integer)results.get(resultAsList);
            if (count == null) {
                results.put(resultAsList, 1);
                continue;
            }
            count = count + 1;
            results.put(resultAsList, count);
        }
        this.verifyResults(results, m, n);
    }

    private void verifyResults(Map<List<Integer>, Integer> results, int m, int n) {
        if (n >= 10) {
            Assert.assertTrue((results.size() >= Math.min(m, 2) ? 1 : 0) != 0);
        }
        for (List<Integer> result : results.keySet()) {
            Assert.assertEquals((long)m, (long)result.size());
            HashSet<Integer> seen = new HashSet<Integer>();
            for (int v : result) {
                System.out.printf("%d ", v);
                Assert.assertTrue((v >= 0 && v < n ? 1 : 0) != 0);
                Assert.assertTrue((boolean)seen.add(v));
            }
            System.out.printf(" ==> %d\n", results.get(result));
        }
        System.out.println("====");
    }

    @Test
    public void testRandomSelect() {
        for (int[] param : parameters) {
            this.testRandomSelect(param[0], param[1], param[2]);
        }
    }

    @Test
    public void testRandomSelectSelector() {
        for (int[] param : parameters) {
            this.testRandomSelectSelector(param[0], param[1], param[2]);
        }
    }
}

