/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.JobCreator;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.StatListener;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.ZombieJobProducer;

abstract class JobFactory<T>
implements Gridmix.Component<Void>,
StatListener<T> {
    public static final Log LOG = LogFactory.getLog(JobFactory.class);
    protected final Path scratch;
    protected final float rateFactor;
    protected final Configuration conf;
    protected final Thread rThread;
    protected final AtomicInteger sequence;
    protected final JobSubmitter submitter;
    protected final CountDownLatch startFlag;
    protected final UserResolver userResolver;
    protected final JobCreator jobCreator;
    protected volatile IOException error = null;
    protected final JobStoryProducer jobProducer;
    protected final ReentrantLock lock = new ReentrantLock(true);
    protected int numJobsInTrace = 0;

    public JobFactory(JobSubmitter submitter, InputStream jobTrace, Path scratch, Configuration conf, CountDownLatch startFlag, UserResolver userResolver) throws IOException {
        this(submitter, (JobStoryProducer)new ZombieJobProducer(jobTrace, null), scratch, conf, startFlag, userResolver);
    }

    protected JobFactory(JobSubmitter submitter, JobStoryProducer jobProducer, Path scratch, Configuration conf, CountDownLatch startFlag, UserResolver userResolver) {
        this.sequence = new AtomicInteger(0);
        this.scratch = scratch;
        this.rateFactor = conf.getFloat("gridmix.submit.multiplier", 1.0f);
        this.jobProducer = jobProducer;
        this.conf = new Configuration(conf);
        this.submitter = submitter;
        this.startFlag = startFlag;
        this.rThread = this.createReaderThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" The submission thread name is " + this.rThread.getName()));
        }
        this.userResolver = userResolver;
        this.jobCreator = JobCreator.getPolicy((Configuration)conf, (JobCreator)JobCreator.LOADJOB);
    }

    protected abstract Thread createReaderThread();

    private JobStory getNextJobFromTrace() throws IOException {
        JobStory story = this.jobProducer.getNextJob();
        if (story != null) {
            ++this.numJobsInTrace;
        }
        return story;
    }

    protected JobStory getNextJobFiltered() throws IOException {
        JobStory job = this.getNextJobFromTrace();
        while (job != null && (job.getOutcome() != Pre21JobHistoryConstants.Values.SUCCESS || job.getSubmissionTime() < 0L)) {
            if (LOG.isDebugEnabled()) {
                String reason = null;
                if (job.getOutcome() != Pre21JobHistoryConstants.Values.SUCCESS) {
                    reason = "STATE (" + job.getOutcome().name() + ") ";
                }
                if (job.getSubmissionTime() < 0L) {
                    reason = reason + "SUBMISSION-TIME (" + job.getSubmissionTime() + ")";
                }
                LOG.debug((Object)("Ignoring job " + job.getJobID() + " from the input trace." + " Reason: " + reason == null ? "N/A" : reason));
            }
            job = this.getNextJobFromTrace();
        }
        return null == job ? null : new /* Unavailable Anonymous Inner Class!! */;
    }

    public IOException error() {
        return this.error;
    }

    public void add(Void ignored) {
        throw new UnsupportedOperationException(this.getClass().getName() + " is at the start of the pipeline and accepts no events");
    }

    public void start() {
        this.rThread.start();
    }

    public void join(long millis) throws InterruptedException {
        this.rThread.join(millis);
    }

    public void shutdown() {
        this.rThread.interrupt();
    }

    public void abort() {
        this.rThread.interrupt();
    }
}

