/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.DummyResourceCalculatorPlugin;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.Progressive;
import org.apache.hadoop.mapred.gridmix.TestGridmixMemoryEmulation;
import org.apache.hadoop.mapred.gridmix.TestHighRamJob;
import org.apache.hadoop.mapred.gridmix.TestResourceUsageEmulators;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.TotalHeapUsageEmulatorPlugin;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.util.ResourceCalculatorPlugin;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestGridmixMemoryEmulation {
    @Test
    public void testHeapUsageEmulator() throws IOException {
        FakeHeapUsageEmulatorCore heapEmulator = new FakeHeapUsageEmulatorCore(null);
        long testSizeInMB = 10L;
        long previousHeap = heapEmulator.getHeapUsageInMB();
        heapEmulator.load(testSizeInMB);
        long currentHeap = heapEmulator.getHeapUsageInMB();
        Assert.assertEquals((String)"Default heap emulator failed to load 10mb", (long)(previousHeap + testSizeInMB), (long)currentHeap);
        heapEmulator.resetFake();
        Assert.assertEquals((String)"Default heap emulator failed to reset", (long)0L, (long)heapEmulator.getHeapUsageInMB());
    }

    @Test
    public void testTotalHeapUsageEmulatorPlugin() throws Exception {
        Configuration conf = new Configuration();
        DummyResourceCalculatorPlugin monitor = new DummyResourceCalculatorPlugin();
        long maxHeapUsage = 1024 * TotalHeapUsageEmulatorPlugin.ONE_MB;
        conf.setLong("mapred.tasktracker.maxpmem.testing", maxHeapUsage);
        monitor.setConf(conf);
        conf.setFloat("gridmix.emulators.resource-usage.heap.min-free-ratio", 0.0f);
        conf.setFloat("gridmix.emulators.resource-usage.heap.load-ratio", 1.0f);
        long targetHeapUsageInMB = 200L;
        TestResourceUsageEmulators.FakeProgressive fakeProgress = new TestResourceUsageEmulators.FakeProgressive();
        FakeHeapUsageEmulatorCore fakeCore = new FakeHeapUsageEmulatorCore(null);
        FakeHeapUsageEmulatorPlugin heapPlugin = new FakeHeapUsageEmulatorPlugin(fakeCore);
        ResourceUsageMetrics invalidUsage = TestResourceUsageEmulators.createMetrics((long)0L);
        heapPlugin.initialize(conf, invalidUsage, null, null);
        int numCallsPre = fakeCore.getNumCalls();
        long heapUsagePre = fakeCore.getHeapUsageInMB();
        heapPlugin.emulate();
        int numCallsPost = fakeCore.getNumCalls();
        long heapUsagePost = fakeCore.getHeapUsageInMB();
        Assert.assertEquals((String)"Disabled heap usage emulation plugin works!", (long)numCallsPre, (long)numCallsPost);
        Assert.assertEquals((String)"Disabled heap usage emulation plugin works!", (long)heapUsagePre, (long)heapUsagePost);
        Boolean failed = null;
        invalidUsage = TestResourceUsageEmulators.createMetrics((long)(maxHeapUsage + (long)TotalHeapUsageEmulatorPlugin.ONE_MB));
        try {
            heapPlugin.initialize(conf, invalidUsage, (ResourceCalculatorPlugin)monitor, null);
            failed = false;
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertNotNull((String)"Fail case failure!", (Object)failed);
        Assert.assertTrue((String)"Expected failure!", (boolean)failed);
        ResourceUsageMetrics metrics = TestResourceUsageEmulators.createMetrics((long)(targetHeapUsageInMB * (long)TotalHeapUsageEmulatorPlugin.ONE_MB));
        TestGridmixMemoryEmulation.testEmulationAccuracy((Configuration)conf, (FakeHeapUsageEmulatorCore)fakeCore, (ResourceCalculatorPlugin)monitor, (ResourceUsageMetrics)metrics, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)200L, (long)10L);
        conf.setFloat("gridmix.emulators.resource-usage.heap.emulation-interval", 0.2f);
        TestGridmixMemoryEmulation.testEmulationAccuracy((Configuration)conf, (FakeHeapUsageEmulatorCore)fakeCore, (ResourceCalculatorPlugin)monitor, (ResourceUsageMetrics)metrics, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)200L, (long)5L);
        conf.setFloat("gridmix.emulators.resource-usage.heap.load-ratio", 1.0f);
        conf.setFloat("gridmix.emulators.resource-usage.heap.min-free-ratio", 0.5f);
        TestGridmixMemoryEmulation.testEmulationAccuracy((Configuration)conf, (FakeHeapUsageEmulatorCore)fakeCore, (ResourceCalculatorPlugin)monitor, (ResourceUsageMetrics)metrics, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)120L, (long)2L);
        conf.setFloat("gridmix.emulators.resource-usage.heap.load-ratio", 0.5f);
        conf.setFloat("gridmix.emulators.resource-usage.heap.min-free-ratio", 0.0f);
        TestGridmixMemoryEmulation.testEmulationAccuracy((Configuration)conf, (FakeHeapUsageEmulatorCore)fakeCore, (ResourceCalculatorPlugin)monitor, (ResourceUsageMetrics)metrics, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)200L, (long)10L);
        conf.setFloat("gridmix.emulators.resource-usage.heap.min-free-ratio", 0.25f);
        conf.setFloat("gridmix.emulators.resource-usage.heap.load-ratio", 0.5f);
        TestGridmixMemoryEmulation.testEmulationAccuracy((Configuration)conf, (FakeHeapUsageEmulatorCore)fakeCore, (ResourceCalculatorPlugin)monitor, (ResourceUsageMetrics)metrics, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)162L, (long)6L);
        fakeProgress = new TestResourceUsageEmulators.FakeProgressive();
        conf.setFloat("gridmix.emulators.resource-usage.heap.min-free-ratio", 0.0f);
        conf.setFloat("gridmix.emulators.resource-usage.heap.load-ratio", 1.0f);
        conf.setFloat("gridmix.emulators.resource-usage.heap.emulation-interval", 0.25f);
        heapPlugin.initialize(conf, metrics, (ResourceCalculatorPlugin)monitor, (Progressive)fakeProgress);
        fakeCore.resetFake();
        long initHeapUsage = fakeCore.getHeapUsageInMB();
        long initNumCallsUsage = fakeCore.getNumCalls();
        TestGridmixMemoryEmulation.testEmulationBoundary((float)0.0f, (FakeHeapUsageEmulatorCore)fakeCore, (TestResourceUsageEmulators.FakeProgressive)fakeProgress, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)initHeapUsage, (long)initNumCallsUsage, (String)"[no-op, 0 progress]");
        TestGridmixMemoryEmulation.testEmulationBoundary((float)0.24f, (FakeHeapUsageEmulatorCore)fakeCore, (TestResourceUsageEmulators.FakeProgressive)fakeProgress, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)initHeapUsage, (long)initNumCallsUsage, (String)"[no-op, 24% progress]");
        TestGridmixMemoryEmulation.testEmulationBoundary((float)0.25f, (FakeHeapUsageEmulatorCore)fakeCore, (TestResourceUsageEmulators.FakeProgressive)fakeProgress, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)(targetHeapUsageInMB / 4L), (long)1L, (String)"[op, 25% progress]");
        TestGridmixMemoryEmulation.testEmulationBoundary((float)0.8f, (FakeHeapUsageEmulatorCore)fakeCore, (TestResourceUsageEmulators.FakeProgressive)fakeProgress, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)(targetHeapUsageInMB * 4L / 5L), (long)2L, (String)"[op, 80% progress]");
        TestGridmixMemoryEmulation.testEmulationBoundary((float)1.0f, (FakeHeapUsageEmulatorCore)fakeCore, (TestResourceUsageEmulators.FakeProgressive)fakeProgress, (TotalHeapUsageEmulatorPlugin)heapPlugin, (long)targetHeapUsageInMB, (long)3L, (String)"[op, 100% progress]");
    }

    private static void testEmulationAccuracy(Configuration conf, FakeHeapUsageEmulatorCore fakeCore, ResourceCalculatorPlugin monitor, ResourceUsageMetrics metrics, TotalHeapUsageEmulatorPlugin heapPlugin, long expectedTotalHeapUsageInMB, long expectedTotalNumCalls) throws Exception {
        TestResourceUsageEmulators.FakeProgressive fakeProgress = new TestResourceUsageEmulators.FakeProgressive();
        fakeCore.resetFake();
        heapPlugin.initialize(conf, metrics, monitor, (Progressive)fakeProgress);
        int numLoops = 0;
        while (fakeProgress.getProgress() < 1.0f) {
            float progress = (float)(++numLoops) / 100.0f;
            fakeProgress.setProgress(progress);
            heapPlugin.emulate();
        }
        Assert.assertEquals((String)"Cumulative heap usage emulator plugin failed (total usage)!", (double)expectedTotalHeapUsageInMB, (double)fakeCore.getHeapUsageInMB(), (double)1.0);
        Assert.assertEquals((String)"Cumulative heap usage emulator plugin failed (num calls)!", (double)expectedTotalNumCalls, (double)fakeCore.getNumCalls(), (double)0.0);
    }

    private static void testEmulationBoundary(float progress, FakeHeapUsageEmulatorCore fakeCore, TestResourceUsageEmulators.FakeProgressive fakeProgress, TotalHeapUsageEmulatorPlugin heapPlugin, long expectedTotalHeapUsageInMB, long expectedTotalNumCalls, String info) throws Exception {
        fakeProgress.setProgress(progress);
        heapPlugin.emulate();
        Assert.assertEquals((String)("Emulation interval test for heap usage failed " + info + "!"), (double)expectedTotalHeapUsageInMB, (double)fakeCore.getHeapUsageInMB(), (double)0.0);
        Assert.assertEquals((String)("Emulation interval test for heap usage failed " + info + "!"), (double)expectedTotalNumCalls, (double)fakeCore.getNumCalls(), (double)0.0);
    }

    private void testJavaHeapOptions(String mapOptions, String reduceOptions, String taskOptions, String defaultMapOptions, String defaultReduceOptions, String defaultTaskOptions, String expectedMapOptions, String expectedReduceOptions, String expectedTaskOptions) throws Exception {
        Configuration simulatedConf = new Configuration();
        simulatedConf.unset("mapreduce.map.java.opts");
        simulatedConf.unset("mapreduce.reduce.java.opts");
        simulatedConf.unset("mapred.child.java.opts");
        if (defaultMapOptions != null) {
            simulatedConf.set("mapreduce.map.java.opts", defaultMapOptions);
        }
        if (defaultReduceOptions != null) {
            simulatedConf.set("mapreduce.reduce.java.opts", defaultReduceOptions);
        }
        if (defaultTaskOptions != null) {
            simulatedConf.set("mapred.child.java.opts", defaultTaskOptions);
        }
        Configuration originalConf = new Configuration();
        originalConf.unset("mapreduce.map.java.opts");
        originalConf.unset("mapreduce.reduce.java.opts");
        originalConf.unset("mapred.child.java.opts");
        if (mapOptions != null) {
            originalConf.set("mapreduce.map.java.opts", mapOptions);
        }
        if (reduceOptions != null) {
            originalConf.set("mapreduce.reduce.java.opts", reduceOptions);
        }
        if (taskOptions != null) {
            originalConf.set("mapred.child.java.opts", taskOptions);
        }
        GridmixJob.configureTaskJVMOptions((Configuration)originalConf, (Configuration)simulatedConf);
        Assert.assertEquals((String)"Map heap options mismatch!", (Object)expectedMapOptions, (Object)simulatedConf.get("mapreduce.map.java.opts"));
        Assert.assertEquals((String)"Reduce heap options mismatch!", (Object)expectedReduceOptions, (Object)simulatedConf.get("mapreduce.reduce.java.opts"));
        Assert.assertEquals((String)"Task heap options mismatch!", (Object)expectedTaskOptions, (Object)simulatedConf.get("mapred.child.java.opts"));
    }

    @Test
    public void testJavaHeapOptions() throws Exception {
        this.testJavaHeapOptions(null, null, null, null, null, null, null, null, null);
        this.testJavaHeapOptions("-Xms10m", "-Xms20m", "-Xms30m", null, null, null, null, null, null);
        this.testJavaHeapOptions(null, null, null, "-Xms10m", "-Xms20m", "-Xms30m", "-Xms10m", "-Xms20m", "-Xms30m");
        this.testJavaHeapOptions("", "", "", null, null, null, null, null, null);
        this.testJavaHeapOptions(null, null, null, "", "", "", "", "", "");
        this.testJavaHeapOptions("", "", "", "-Xmx10m -Xms1m", "-Xmx50m -Xms2m", "-Xms2m -Xmx100m", "-Xmx10m -Xms1m", "-Xmx50m -Xms2m", "-Xms2m -Xmx100m");
        this.testJavaHeapOptions("-Xmx10m", "-Xmx20m", "-Xmx30m", null, null, null, "-Xmx10m", "-Xmx20m", "-Xmx30m");
        this.testJavaHeapOptions("-Xms5m -Xmx200m", "-Xms15m -Xmx300m", "-Xms25m -Xmx50m", "-XXabc", "-XXxyz", "-XXdef", "-XXabc -Xmx200m", "-XXxyz -Xmx300m", "-XXdef -Xmx50m");
        this.testJavaHeapOptions("-Xms5m -Xmx200m", "-Xms15m -Xmx300m", "-Xms25m -Xmx50m", "-XXabc -Xmx500m", "-XXxyz -Xmx600m", "-XXdef -Xmx700m", "-XXabc -Xmx200m", "-XXxyz -Xmx300m", "-XXdef -Xmx50m");
        this.testJavaHeapOptions("-Xmx10m", "-Xmx20m", "-Xmx50m", "-Xms2m", "-Xms3m", "-Xms5m", "-Xms2m -Xmx10m", "-Xms3m -Xmx20m", "-Xms5m -Xmx50m");
        this.testJavaHeapOptions("-Xmx10m", "-Xmx20m", "-Xmx50m", "-Xmx2m", "-Xmx3m", "-Xmx5m", "-Xmx10m", "-Xmx20m", "-Xmx50m");
    }

    @Test
    public void testJavaHeapOptionsDisabled() throws Exception {
        Configuration gridmixConf = new Configuration();
        gridmixConf.setBoolean("gridmix.task.jvm-options.enable", false);
        gridmixConf.set("mapreduce.map.java.opts", "-Xmx1m");
        gridmixConf.set("mapreduce.reduce.java.opts", "-Xmx2m");
        gridmixConf.set("mapred.child.java.opts", "-Xmx3m");
        JobConf originalConf = new JobConf();
        originalConf.set("mapreduce.map.java.opts", "-Xmx10m");
        originalConf.set("mapreduce.reduce.java.opts", "-Xmx20m");
        originalConf.set("mapred.child.java.opts", "-Xmx30m");
        1 story = new /* Unavailable Anonymous Inner Class!! */;
        TestHighRamJob.DummyGridmixJob job = new TestHighRamJob.DummyGridmixJob(gridmixConf, (JobStory)story);
        Job simulatedJob = job.getJob();
        Configuration simulatedConf = simulatedJob.getConfiguration();
        Assert.assertEquals((String)"Map heap options works when disabled!", (Object)"-Xmx1m", (Object)simulatedConf.get("mapreduce.map.java.opts"));
        Assert.assertEquals((String)"Reduce heap options works when disabled!", (Object)"-Xmx2m", (Object)simulatedConf.get("mapreduce.reduce.java.opts"));
        Assert.assertEquals((String)"Task heap options works when disabled!", (Object)"-Xmx3m", (Object)simulatedConf.get("mapred.child.java.opts"));
    }
}

