/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix.emulators.resourceusage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.Progressive;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.CumulativeCpuUsageEmulatorPlugin;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.ResourceUsageEmulatorPlugin;
import org.apache.hadoop.mapreduce.util.ResourceCalculatorPlugin;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;

public class CumulativeCpuUsageEmulatorPlugin
implements ResourceUsageEmulatorPlugin {
    protected CpuUsageEmulatorCore emulatorCore;
    private ResourceCalculatorPlugin monitor;
    private Progressive progress;
    private boolean enabled = true;
    private float emulationInterval;
    private long targetCpuUsage = 0L;
    private float lastSeenProgress = 0.0f;
    private long lastSeenCpuUsageCpuUsage = 0L;
    public static final String CPU_EMULATION_PROGRESS_INTERVAL = "gridmix.emulators.resource-usage.cpu.emulation-interval";
    private static final float DEFAULT_EMULATION_FREQUENCY = 0.1f;

    public CumulativeCpuUsageEmulatorPlugin() {
        this((CpuUsageEmulatorCore)new DefaultCpuUsageEmulator());
    }

    public CumulativeCpuUsageEmulatorPlugin(CpuUsageEmulatorCore core) {
        this.emulatorCore = core;
    }

    private float getWeightForProgressInterval(float progress) {
        return progress * progress * progress * progress;
    }

    public void emulate() throws IOException, InterruptedException {
        float currentProgress;
        if (this.enabled && this.lastSeenProgress < (currentProgress = this.progress.getProgress()) && (currentProgress - this.lastSeenProgress >= this.emulationInterval || currentProgress == 1.0f)) {
            float rate;
            long currentCpuUsage = this.monitor.getProcResourceValues().getCumulativeCpuTime();
            long projectedUsage = currentCpuUsage + (long)((1.0f - currentProgress) * (rate = (float)(currentCpuUsage - this.lastSeenCpuUsageCpuUsage) / (currentProgress - this.lastSeenProgress)));
            if (projectedUsage < this.targetCpuUsage) {
                long currentWeighedTarget = (long)((float)this.targetCpuUsage * this.getWeightForProgressInterval(currentProgress));
                while (this.monitor.getProcResourceValues().getCumulativeCpuTime() < currentWeighedTarget) {
                    this.emulatorCore.compute();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        String message = "CumulativeCpuUsageEmulatorPlugin got interrupted. Exiting.";
                        throw new RuntimeException(message);
                    }
                }
            }
            this.lastSeenProgress = this.progress.getProgress();
            this.lastSeenCpuUsageCpuUsage = this.monitor.getProcResourceValues().getCumulativeCpuTime();
        }
    }

    public void initialize(Configuration conf, ResourceUsageMetrics metrics, ResourceCalculatorPlugin monitor, Progressive progress) {
        this.targetCpuUsage = metrics.getCumulativeCpuUsage();
        if (this.targetCpuUsage <= 0L) {
            this.enabled = false;
            return;
        }
        this.enabled = true;
        this.monitor = monitor;
        this.progress = progress;
        this.emulationInterval = conf.getFloat(CPU_EMULATION_PROGRESS_INTERVAL, 0.1f);
        this.emulatorCore.calibrate(monitor, this.targetCpuUsage);
        this.lastSeenProgress = 0.0f;
        this.lastSeenCpuUsageCpuUsage = 0L;
    }
}

