/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.gridmix.JobCreator;
import org.apache.hadoop.mapred.gridmix.PseudoLocalFs;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Evolving
class DistributedCacheEmulator {
    private static final Log LOG = LogFactory.getLog(DistributedCacheEmulator.class);
    static final long AVG_BYTES_PER_MAP = 0x8000000L;
    private Path distCachePath;
    private Map<String, Long> distCacheFiles = new HashMap();
    static final String GRIDMIX_EMULATE_DISTRIBUTEDCACHE = "gridmix.distributed-cache-emulation.enable";
    boolean emulateDistributedCache = true;
    boolean generateDistCacheData = false;
    Configuration conf;
    private static final Charset charsetUTF8 = Charset.forName("UTF-8");
    FileSystem pseudoLocalFs = null;

    public DistributedCacheEmulator(Configuration conf, Path ioPath) {
        Configuration.addDeprecations((Configuration.DeprecationDelta[])new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("mapred.cache.files.filesizes", "mapreduce.job.cache.files.filesizes"), new Configuration.DeprecationDelta("mapred.cache.files.visibilities", "mapreduce.job.cache.files.visibilities")});
        this.conf = conf;
        this.distCachePath = new Path(ioPath, "distributedCache");
        this.conf.setClass("fs.pseudo.impl", PseudoLocalFs.class, FileSystem.class);
    }

    void init(String traceIn, JobCreator jobCreator, boolean generate) throws IOException {
        this.emulateDistributedCache = jobCreator.canEmulateDistCacheLoad() && this.conf.getBoolean("gridmix.distributed-cache-emulation.enable", true);
        this.generateDistCacheData = generate;
        if (this.generateDistCacheData || this.emulateDistributedCache) {
            if ("-".equals(traceIn)) {
                LOG.warn((Object)"Gridmix will not emulate Distributed Cache load because the input trace source is a stream instead of file.");
                this.generateDistCacheData = false;
                this.emulateDistributedCache = false;
            } else if (FileSystem.getLocal((Configuration)this.conf).getUri().getScheme().equals(this.distCachePath.toUri().getScheme())) {
                LOG.warn((Object)"Gridmix will not emulate Distributed Cache load because <iopath> provided is on local file system.");
                this.generateDistCacheData = false;
                this.emulateDistributedCache = false;
            } else {
                FileSystem fs = FileSystem.get((Configuration)this.conf);
                for (Path cur = this.distCachePath.getParent(); cur != null; cur = cur.getParent()) {
                    FsPermission perm;
                    if (cur.toString().length() <= 0 || (perm = fs.getFileStatus(cur).getPermission()).getOtherAction().and(FsAction.EXECUTE).equals((Object)FsAction.EXECUTE)) continue;
                    LOG.warn((Object)("Gridmix will not emulate Distributed Cache load because the ascendant directory (of distributed cache directory) " + cur + " doesn't have execute permission " + "for others."));
                    this.generateDistCacheData = false;
                    this.emulateDistributedCache = false;
                    break;
                }
            }
        }
        try {
            this.pseudoLocalFs = FileSystem.get((URI)new URI("pseudo:///"), (Configuration)this.conf);
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)"Gridmix will not emulate Distributed Cache load because creation of pseudo local file system failed.");
            e.printStackTrace();
            this.generateDistCacheData = false;
            this.emulateDistributedCache = false;
            return;
        }
    }

    boolean shouldEmulateDistCacheLoad() {
        return this.emulateDistributedCache;
    }

    boolean shouldGenerateDistCacheData() {
        return this.generateDistCacheData;
    }

    Path getDistributedCacheDir() {
        return this.distCachePath;
    }

    int setupGenerateDistCacheData(JobStoryProducer jsp) throws IOException {
        this.createDistCacheDirectory();
        return this.buildDistCacheFilesList(jsp);
    }

    private void createDistCacheDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileSystem.mkdirs((FileSystem)fs, (Path)this.distCachePath, (FsPermission)new FsPermission(511));
    }

    private int buildDistCacheFilesList(JobStoryProducer jsp) throws IOException {
        JobStory jobStory;
        while ((jobStory = jsp.getNextJob()) != null) {
            if (jobStory.getOutcome() != Pre21JobHistoryConstants.Values.SUCCESS || jobStory.getSubmissionTime() < 0L) continue;
            this.updateHDFSDistCacheFilesList(jobStory);
        }
        jsp.close();
        return this.writeDistCacheFilesList();
    }

    void updateHDFSDistCacheFilesList(JobStory jobdesc) throws IOException {
        JobConf jobConf = jobdesc.getJobConf();
        String[] files = jobConf.getStrings("mapreduce.job.cache.files");
        if (files != null) {
            String[] fileSizes = jobConf.getStrings("mapreduce.job.cache.files.filesizes");
            String[] visibilities = jobConf.getStrings("mapreduce.job.cache.files.visibilities");
            String[] timeStamps = jobConf.getStrings("mapreduce.job.cache.files.timestamps");
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            String user = jobConf.getUser();
            for (int i = 0; i < files.length; ++i) {
                String mappedPath;
                boolean visibility;
                boolean bl = visibility = visibilities == null ? true : Boolean.valueOf(visibilities[i]);
                if (DistributedCacheEmulator.isLocalDistCacheFile((String)files[i], (String)user, (boolean)visibility) || this.distCacheFiles.containsKey(mappedPath = this.mapDistCacheFilePath(files[i], timeStamps[i], visibility, user)) || fs.exists(new Path(mappedPath))) continue;
                this.distCacheFiles.put(mappedPath, Long.valueOf(fileSizes[i]));
            }
        }
    }

    static boolean isLocalDistCacheFile(String filePath, String user, boolean visibility) {
        return !visibility && filePath.contains(user + "/.staging");
    }

    private String mapDistCacheFilePath(String file, String timeStamp, boolean isPublic, String user) {
        String id = file + timeStamp;
        if (!isPublic) {
            id = id.concat(user);
        }
        return new Path(this.distCachePath, MD5Hash.digest((String)id).toString()).toUri().getPath();
    }

    private int writeDistCacheFilesList() throws IOException {
        ArrayList dcFiles = new ArrayList(this.distCacheFiles.entrySet());
        Collections.sort(dcFiles, new /* Unavailable Anonymous Inner Class!! */);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path distCacheFilesList = new Path(this.distCachePath, "_distCacheFiles.txt");
        this.conf.set("gridmix.distcache.file.list", distCacheFilesList.toString());
        SequenceFile.Writer src_writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)distCacheFilesList, LongWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        int fileCount = dcFiles.size();
        long byteCount = 0L;
        long bytesSync = 0L;
        for (Map.Entry entry : dcFiles) {
            LongWritable fileSize = new LongWritable(Long.parseLong(entry.getValue().toString()));
            BytesWritable filePath = new BytesWritable(entry.getKey().toString().getBytes(charsetUTF8));
            byteCount += fileSize.get();
            if ((bytesSync += fileSize.get()) > 0x8000000L) {
                src_writer.sync();
                bytesSync = fileSize.get();
            }
            src_writer.append((Writable)fileSize, (Writable)filePath);
        }
        if (src_writer != null) {
            src_writer.close();
        }
        fs.deleteOnExit(distCacheFilesList);
        this.conf.setInt("gridmix.distcache.file.count", fileCount);
        this.conf.setLong("gridmix.distcache.byte.count", byteCount);
        LOG.info((Object)("Number of HDFS based distributed cache files to be generated is " + fileCount + ". Total size of HDFS based distributed cache files " + "to be generated is " + byteCount));
        if (!this.shouldGenerateDistCacheData() && fileCount > 0) {
            LOG.error((Object)("Missing " + fileCount + " distributed cache files under the " + " directory\n" + this.distCachePath + "\nthat are needed for gridmix" + " to emulate distributed cache load. Either use -generate\noption" + " to generate distributed cache data along with input data OR " + "disable\ndistributed cache emulation by configuring '" + "gridmix.distributed-cache-emulation.enable" + "' to false."));
            return 3;
        }
        return 0;
    }

    void configureDistCacheFiles(Configuration conf, JobConf jobConf) throws IOException {
        String[] files;
        if (this.shouldEmulateDistCacheLoad() && (files = jobConf.getStrings("mapreduce.job.cache.files")) != null) {
            ArrayList<String> cacheFiles = new ArrayList<String>();
            ArrayList<String> localCacheFiles = new ArrayList<String>();
            String[] visibilities = jobConf.getStrings("mapreduce.job.cache.files.visibilities");
            String[] timeStamps = jobConf.getStrings("mapreduce.job.cache.files.timestamps");
            String[] fileSizes = jobConf.getStrings("mapreduce.job.cache.files.filesizes");
            String user = jobConf.getUser();
            for (int i = 0; i < files.length; ++i) {
                boolean visibility;
                boolean bl = visibility = visibilities == null ? true : Boolean.valueOf(visibilities[i]);
                if (DistributedCacheEmulator.isLocalDistCacheFile((String)files[i], (String)user, (boolean)visibility)) {
                    String fileId = MD5Hash.digest((String)(files[i] + timeStamps[i])).toString();
                    long fileSize = Long.parseLong(fileSizes[i]);
                    Path mappedLocalFilePath = PseudoLocalFs.generateFilePath((String)fileId, (long)fileSize).makeQualified(this.pseudoLocalFs.getUri(), this.pseudoLocalFs.getWorkingDirectory());
                    this.pseudoLocalFs.create(mappedLocalFilePath);
                    localCacheFiles.add(mappedLocalFilePath.toUri().toString());
                    continue;
                }
                String mappedPath = this.mapDistCacheFilePath(files[i], timeStamps[i], visibility, user);
                cacheFiles.add(mappedPath);
            }
            if (cacheFiles.size() > 0) {
                conf.setStrings("mapreduce.job.cache.files", cacheFiles.toArray(new String[cacheFiles.size()]));
            }
            if (localCacheFiles.size() > 0) {
                conf.setStrings("tmpfiles", localCacheFiles.toArray(new String[localCacheFiles.size()]));
            }
        }
    }
}

