/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public final class StringUtils {
    private static final String UTF8_CSN = StandardCharsets.UTF_8.name();

    private StringUtils() {
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    public static String bytes2String(byte[] bytes) {
        return StringUtils.bytes2String(bytes, 0, bytes.length);
    }

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes(UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 decoding is not supported", e);
        }
    }
}

