/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.time.Duration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.fs.DU;
import org.apache.hadoop.hdds.fs.SaveSpaceUsageToFile;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;

public class DUFactory
implements SpaceUsageCheckFactory {
    private static final String DU_CACHE_FILE = "scmUsed";
    private static final String EXCLUDE_PATTERN = "*.tmp.*";
    private static final String CONFIG_PREFIX = "hdds.datanode.du";
    private Conf conf;

    @Override
    public SpaceUsageCheckFactory setConfiguration(Configuration configuration) {
        this.conf = OzoneConfiguration.of(configuration).getObject(Conf.class);
        return this;
    }

    @Override
    public SpaceUsageCheckParams paramsFor(File dir) {
        Duration refreshPeriod = this.conf.getRefreshPeriod();
        DU source = new DU(dir, EXCLUDE_PATTERN);
        SaveSpaceUsageToFile persistence = new SaveSpaceUsageToFile(new File(dir, DU_CACHE_FILE), refreshPeriod);
        return new SpaceUsageCheckParams(dir, source, refreshPeriod, persistence);
    }

    @ConfigGroup(prefix="hdds.datanode.du")
    public static class Conf {
        private static final String REFRESH_PERIOD = "refresh.period";
        @Config(key="refresh.period", defaultValue="1h", type=ConfigType.TIME, tags={ConfigTag.DATANODE}, description="Disk space usage information will be refreshed with thespecified period following the completion of the last check.")
        private long refreshPeriod;

        public void setRefreshPeriod(long millis) {
            this.refreshPeriod = millis;
        }

        public Duration getRefreshPeriod() {
            return Duration.ofMillis(this.refreshPeriod);
        }

        static String configKeyForRefreshPeriod() {
            return "hdds.datanode.du.refresh.period";
        }
    }
}

