/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocol;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.net.NodeImpl;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeDetails
extends NodeImpl
implements Comparable<DatanodeDetails> {
    private final UUID uuid;
    private String ipAddress;
    private String hostName;
    private List<Port> ports;
    private String certSerialId;

    private DatanodeDetails(String uuid, String ipAddress, String hostName, String networkLocation, List<Port> ports, String certSerialId) {
        super(hostName, networkLocation, 0);
        this.uuid = UUID.fromString(uuid);
        this.ipAddress = ipAddress;
        this.hostName = hostName;
        this.ports = ports;
        this.certSerialId = certSerialId;
    }

    protected DatanodeDetails(DatanodeDetails datanodeDetails) {
        super(datanodeDetails.getHostName(), datanodeDetails.getNetworkLocation(), datanodeDetails.getCost());
        this.uuid = datanodeDetails.uuid;
        this.ipAddress = datanodeDetails.ipAddress;
        this.hostName = datanodeDetails.hostName;
        this.ports = datanodeDetails.ports;
        this.setNetworkName(datanodeDetails.getNetworkName());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUuidString() {
        return this.uuid.toString();
    }

    public void setIpAddress(String ip) {
        this.ipAddress = ip;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(Port port) {
        this.ports.remove(port);
        this.ports.add(port);
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public Port getPort(Port.Name name) {
        for (Port port : this.ports) {
            if (!port.getName().equals((Object)name)) continue;
            return port;
        }
        return null;
    }

    public static DatanodeDetails getFromProtoBuf(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        Builder builder = DatanodeDetails.newBuilder();
        builder.setUuid(datanodeDetailsProto.getUuid());
        if (datanodeDetailsProto.hasIpAddress()) {
            builder.setIpAddress(datanodeDetailsProto.getIpAddress());
        }
        if (datanodeDetailsProto.hasHostName()) {
            builder.setHostName(datanodeDetailsProto.getHostName());
        }
        if (datanodeDetailsProto.hasCertSerialId()) {
            builder.setCertSerialId(datanodeDetailsProto.getCertSerialId());
        }
        for (HddsProtos.Port port : datanodeDetailsProto.getPortsList()) {
            builder.addPort(DatanodeDetails.newPort(Port.Name.valueOf(port.getName().toUpperCase()), port.getValue()));
        }
        if (datanodeDetailsProto.hasNetworkName()) {
            builder.setNetworkName(datanodeDetailsProto.getNetworkName());
        }
        if (datanodeDetailsProto.hasNetworkLocation()) {
            builder.setNetworkLocation(datanodeDetailsProto.getNetworkLocation());
        }
        return builder.build();
    }

    public HddsProtos.DatanodeDetailsProto getProtoBufMessage() {
        HddsProtos.DatanodeDetailsProto.Builder builder = HddsProtos.DatanodeDetailsProto.newBuilder().setUuid(this.getUuidString());
        if (this.ipAddress != null) {
            builder.setIpAddress(this.ipAddress);
        }
        if (this.hostName != null) {
            builder.setHostName(this.hostName);
        }
        if (this.certSerialId != null) {
            builder.setCertSerialId(this.certSerialId);
        }
        if (!Strings.isNullOrEmpty((String)this.getNetworkName())) {
            builder.setNetworkName(this.getNetworkName());
        }
        if (!Strings.isNullOrEmpty((String)this.getNetworkLocation())) {
            builder.setNetworkLocation(this.getNetworkLocation());
        }
        for (Port port : this.ports) {
            builder.addPorts(HddsProtos.Port.newBuilder().setName(port.getName().toString()).setValue(port.getValue()).build());
        }
        return builder.build();
    }

    @Override
    public String toString() {
        return this.uuid.toString() + "{ip: " + this.ipAddress + ", host: " + this.hostName + ", networkLocation: " + this.getNetworkLocation() + ", certSerialId: " + this.certSerialId + "}";
    }

    @Override
    public int compareTo(DatanodeDetails that) {
        return this.getUuid().compareTo(that.getUuid());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DatanodeDetails && this.uuid.equals(((DatanodeDetails)obj).uuid);
    }

    @Override
    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Port newPort(Port.Name name, Integer value) {
        return new Port(name, value);
    }

    public String getCertSerialId() {
        return this.certSerialId;
    }

    public void setCertSerialId(String certSerialId) {
        this.certSerialId = certSerialId;
    }

    public static final class Port {
        private Name name;
        private Integer value;

        private Port(Name name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public Name getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Port) {
                return this.name.equals((Object)((Port)anObject).name);
            }
            return false;
        }

        public static enum Name {
            STANDALONE,
            RATIS,
            REST;

        }
    }

    public static final class Builder {
        private String id;
        private String ipAddress;
        private String hostName;
        private String networkName;
        private String networkLocation;
        private List<Port> ports = new ArrayList<Port>();
        private String certSerialId;

        private Builder() {
        }

        public Builder setUuid(String uuid) {
            this.id = uuid;
            return this;
        }

        public Builder setIpAddress(String ip) {
            this.ipAddress = ip;
            return this;
        }

        public Builder setHostName(String host) {
            this.hostName = host;
            return this;
        }

        public Builder setNetworkName(String name) {
            this.networkName = name;
            return this;
        }

        public Builder setNetworkLocation(String loc) {
            this.networkLocation = loc;
            return this;
        }

        public Builder addPort(Port port) {
            this.ports.add(port);
            return this;
        }

        public Builder setCertSerialId(String certId) {
            this.certSerialId = certId;
            return this;
        }

        public DatanodeDetails build() {
            Preconditions.checkNotNull((Object)this.id);
            if (this.networkLocation == null) {
                this.networkLocation = "/default-rack";
            }
            DatanodeDetails dn = new DatanodeDetails(this.id, this.ipAddress, this.hostName, this.networkLocation, this.ports, this.certSerialId);
            if (this.networkName != null) {
                dn.setNetworkName(this.networkName);
            }
            return dn;
        }
    }
}

