/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.freon;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeClusterTopology {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeClusterTopology.class);
    public static final FakeClusterTopology INSTANCE = new FakeClusterTopology();
    private List<HddsProtos.DatanodeDetailsProto> datanodes = new ArrayList<HddsProtos.DatanodeDetailsProto>();
    private List<HddsProtos.Pipeline> pipelines = new ArrayList<HddsProtos.Pipeline>();
    private Random random = new Random();

    public FakeClusterTopology() {
        try {
            for (int i = 0; i < 9; ++i) {
                this.datanodes.add(this.createDatanode(i));
                if ((i + 1) % 3 != 0) continue;
                this.pipelines.add(HddsProtos.Pipeline.newBuilder().setId(PipelineID.randomId().getProtobuf()).setFactor(HddsProtos.ReplicationFactor.THREE).setType(HddsProtos.ReplicationType.RATIS).addMembers(this.getDatanode(i - 2)).addMembers(this.getDatanode(i - 1)).addMembers(this.getDatanode(i)).build());
            }
        }
        catch (Exception ex) {
            LOGGER.error("Can't initialize FakeClusterTopology", (Throwable)ex);
        }
    }

    private HddsProtos.DatanodeDetailsProto createDatanode(int index) {
        return HddsProtos.DatanodeDetailsProto.newBuilder().setUuid(UUID.randomUUID().toString()).setHostName("localhost").setIpAddress("127.0.0.1").addPorts(HddsProtos.Port.newBuilder().setName("RATIS").setValue(1234)).build();
    }

    public HddsProtos.DatanodeDetailsProto getDatanode(int i) {
        return this.datanodes.get(i);
    }

    public HddsProtos.Pipeline getRandomPipeline() {
        return this.pipelines.get(this.random.nextInt(this.pipelines.size()));
    }

    public List<HddsProtos.DatanodeDetailsProto> getAllDatanodes() {
        return this.datanodes;
    }
}

