/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.UnknownPipelineStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pipeline {
    private static final Logger LOG = LoggerFactory.getLogger(Pipeline.class);
    private final PipelineID id;
    private final HddsProtos.ReplicationType type;
    private final HddsProtos.ReplicationFactor factor;
    private PipelineState state;
    private Map<DatanodeDetails, Long> nodeStatus;
    private ThreadLocal<List<DatanodeDetails>> nodesInOrder = new ThreadLocal();
    private UUID leaderId;
    private Instant creationTimestamp;

    private Pipeline(PipelineID id, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, PipelineState state, Map<DatanodeDetails, Long> nodeStatus) {
        this.id = id;
        this.type = type;
        this.factor = factor;
        this.state = state;
        this.nodeStatus = nodeStatus;
        this.creationTimestamp = Instant.now();
    }

    public PipelineID getId() {
        return this.id;
    }

    public HddsProtos.ReplicationType getType() {
        return this.type;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }

    public PipelineState getPipelineState() {
        return this.state;
    }

    public Instant getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(Instant creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public UUID getLeaderId() {
        return this.leaderId;
    }

    void setLeaderId(UUID leaderId) {
        this.leaderId = leaderId;
    }

    public List<DatanodeDetails> getNodes() {
        return new ArrayList<DatanodeDetails>(this.nodeStatus.keySet());
    }

    public Set<DatanodeDetails> getNodeSet() {
        return Collections.unmodifiableSet(this.nodeStatus.keySet());
    }

    public boolean sameDatanodes(Pipeline pipeline) {
        return this.getNodeSet().equals(pipeline.getNodeSet());
    }

    public DatanodeDetails getLeaderNode() throws IOException {
        if (this.nodeStatus.isEmpty()) {
            throw new IOException(String.format("Pipeline=%s is empty", this.id));
        }
        Optional<DatanodeDetails> datanodeDetails = this.nodeStatus.keySet().stream().filter(d -> d.getUuid().equals(this.leaderId)).findFirst();
        if (datanodeDetails.isPresent()) {
            return datanodeDetails.get();
        }
        return this.getClosestNode();
    }

    public DatanodeDetails getFirstNode() throws IOException {
        if (this.nodeStatus.isEmpty()) {
            throw new IOException(String.format("Pipeline=%s is empty", this.id));
        }
        return this.nodeStatus.keySet().iterator().next();
    }

    public DatanodeDetails getClosestNode() throws IOException {
        if (this.nodesInOrder.get() == null || this.nodesInOrder.get().isEmpty()) {
            LOG.debug("Nodes in order is empty, delegate to getFirstNode");
            return this.getFirstNode();
        }
        return this.nodesInOrder.get().get(0);
    }

    public boolean isClosed() {
        return this.state == PipelineState.CLOSED;
    }

    public boolean isOpen() {
        return this.state == PipelineState.OPEN;
    }

    public boolean isAllocationTimeout() {
        return false;
    }

    public void setNodesInOrder(List<DatanodeDetails> nodes) {
        this.nodesInOrder.set(nodes);
    }

    public List<DatanodeDetails> getNodesInOrder() {
        if (this.nodesInOrder.get() == null || this.nodesInOrder.get().isEmpty()) {
            LOG.debug("Nodes in order is empty, delegate to getNodes");
            return this.getNodes();
        }
        return this.nodesInOrder.get();
    }

    void reportDatanode(DatanodeDetails dn) throws IOException {
        if (this.nodeStatus.get(dn) == null) {
            throw new IOException(String.format("Datanode=%s not part of pipeline=%s", dn, this.id));
        }
        this.nodeStatus.put(dn, System.currentTimeMillis());
    }

    public boolean isHealthy() {
        for (Long reportedTime : this.nodeStatus.values()) {
            if (reportedTime >= 0L) continue;
            return false;
        }
        return this.leaderId != null;
    }

    public boolean isEmpty() {
        return this.nodeStatus.isEmpty();
    }

    public HddsProtos.Pipeline getProtobufMessage() throws UnknownPipelineStateException {
        List<DatanodeDetails> nodes;
        ArrayList<HddsProtos.DatanodeDetailsProto> members = new ArrayList<HddsProtos.DatanodeDetailsProto>();
        for (DatanodeDetails dn : this.nodeStatus.keySet()) {
            members.add(dn.getProtoBufMessage());
        }
        HddsProtos.Pipeline.Builder builder = HddsProtos.Pipeline.newBuilder().setId(this.id.getProtobuf()).setType(this.type).setFactor(this.factor).setState(PipelineState.getProtobuf(this.state)).setLeaderID(this.leaderId != null ? this.leaderId.toString() : "").setCreationTimeStamp(this.creationTimestamp.toEpochMilli()).addAllMembers(members);
        if (this.leaderId != null) {
            HddsProtos.UUID uuid128 = HddsProtos.UUID.newBuilder().setMostSigBits(this.leaderId.getMostSignificantBits()).setLeastSigBits(this.leaderId.getLeastSignificantBits()).build();
            builder.setLeaderID128(uuid128);
        }
        if ((nodes = this.nodesInOrder.get()) != null && !nodes.isEmpty()) {
            block1: for (int i = 0; i < nodes.size(); ++i) {
                Iterator<DatanodeDetails> it = this.nodeStatus.keySet().iterator();
                for (int j = 0; j < this.nodeStatus.keySet().size(); ++j) {
                    if (!it.next().equals(nodes.get(i))) continue;
                    builder.addMemberOrders(j);
                    continue block1;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serialize pipeline {} with nodesInOrder {}", (Object)this.id, nodes);
            }
        }
        return builder.build();
    }

    public static Pipeline getFromProtobuf(HddsProtos.Pipeline pipeline) throws UnknownPipelineStateException {
        Preconditions.checkNotNull((Object)pipeline, (Object)"Pipeline is null");
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        for (HddsProtos.DatanodeDetailsProto member : pipeline.getMembersList()) {
            nodes.add(DatanodeDetails.getFromProtoBuf(member));
        }
        UUID leaderId = null;
        if (pipeline.hasLeaderID128()) {
            HddsProtos.UUID uuid = pipeline.getLeaderID128();
            leaderId = new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits());
        } else if (pipeline.hasLeaderID() && StringUtils.isNotEmpty((CharSequence)pipeline.getLeaderID())) {
            leaderId = UUID.fromString(pipeline.getLeaderID());
        }
        return new Builder().setId(PipelineID.getFromProtobuf(pipeline.getId())).setFactor(pipeline.getFactor()).setType(pipeline.getType()).setState(PipelineState.fromProtobuf(pipeline.getState())).setNodes(nodes).setLeaderId(leaderId).setNodesInOrder(pipeline.getMemberOrdersList()).setCreateTimestamp(pipeline.getCreationTimeStamp()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline that = (Pipeline)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.type, (Object)that.type).append((Object)this.factor, (Object)that.factor).append(this.getNodes(), that.getNodes()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.type).append((Object)this.factor).append(this.nodeStatus).toHashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append("[");
        b.append(" Id: ").append(this.id.getId());
        b.append(", Nodes: ");
        this.nodeStatus.keySet().forEach(b::append);
        b.append(", Type:").append(this.getType());
        b.append(", Factor:").append(this.getFactor());
        b.append(", State:").append((Object)this.getPipelineState());
        b.append(", leaderId:").append(this.leaderId != null ? this.leaderId.toString() : "");
        b.append(", CreationTimestamp").append(this.getCreationTimestamp());
        b.append("]");
        return b.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Pipeline pipeline) {
        return new Builder(pipeline);
    }

    public static enum PipelineState {
        ALLOCATED,
        OPEN,
        DORMANT,
        CLOSED;


        public static PipelineState fromProtobuf(HddsProtos.PipelineState state) throws UnknownPipelineStateException {
            Preconditions.checkNotNull((Object)state, (Object)"Pipeline state is null");
            switch (state) {
                case PIPELINE_ALLOCATED: {
                    return ALLOCATED;
                }
                case PIPELINE_OPEN: {
                    return OPEN;
                }
                case PIPELINE_DORMANT: {
                    return DORMANT;
                }
                case PIPELINE_CLOSED: {
                    return CLOSED;
                }
            }
            throw new UnknownPipelineStateException("Pipeline state: " + state + " is not recognized.");
        }

        public static HddsProtos.PipelineState getProtobuf(PipelineState state) throws UnknownPipelineStateException {
            Preconditions.checkNotNull((Object)((Object)state), (Object)"Pipeline state is null");
            switch (state) {
                case ALLOCATED: {
                    return HddsProtos.PipelineState.PIPELINE_ALLOCATED;
                }
                case OPEN: {
                    return HddsProtos.PipelineState.PIPELINE_OPEN;
                }
                case DORMANT: {
                    return HddsProtos.PipelineState.PIPELINE_DORMANT;
                }
                case CLOSED: {
                    return HddsProtos.PipelineState.PIPELINE_CLOSED;
                }
            }
            throw new UnknownPipelineStateException("Pipeline state: " + (Object)((Object)state) + " is not recognized.");
        }
    }

    public static class Builder {
        private PipelineID id = null;
        private HddsProtos.ReplicationType type = null;
        private HddsProtos.ReplicationFactor factor = null;
        private PipelineState state = null;
        private Map<DatanodeDetails, Long> nodeStatus = null;
        private List<Integer> nodeOrder = null;
        private List<DatanodeDetails> nodesInOrder = null;
        private UUID leaderId = null;
        private Instant creationTimestamp = null;

        public Builder() {
        }

        public Builder(Pipeline pipeline) {
            this.id = pipeline.id;
            this.type = pipeline.type;
            this.factor = pipeline.factor;
            this.state = pipeline.state;
            this.nodeStatus = pipeline.nodeStatus;
            this.nodesInOrder = (List)pipeline.nodesInOrder.get();
            this.leaderId = pipeline.getLeaderId();
            this.creationTimestamp = pipeline.getCreationTimestamp();
        }

        public Builder setId(PipelineID id1) {
            this.id = id1;
            return this;
        }

        public Builder setType(HddsProtos.ReplicationType type1) {
            this.type = type1;
            return this;
        }

        public Builder setFactor(HddsProtos.ReplicationFactor factor1) {
            this.factor = factor1;
            return this;
        }

        public Builder setState(PipelineState state1) {
            this.state = state1;
            return this;
        }

        public Builder setLeaderId(UUID leaderId1) {
            this.leaderId = leaderId1;
            return this;
        }

        public Builder setNodes(List<DatanodeDetails> nodes) {
            this.nodeStatus = new LinkedHashMap<DatanodeDetails, Long>();
            nodes.forEach(node -> this.nodeStatus.put((DatanodeDetails)node, -1L));
            return this;
        }

        public Builder setNodesInOrder(List<Integer> orders) {
            this.nodeOrder = orders;
            return this;
        }

        public Builder setCreateTimestamp(long createTimestamp) {
            this.creationTimestamp = Instant.ofEpochMilli(createTimestamp);
            return this;
        }

        public Pipeline build() {
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)this.type);
            Preconditions.checkNotNull((Object)this.factor);
            Preconditions.checkNotNull((Object)((Object)this.state));
            Preconditions.checkNotNull(this.nodeStatus);
            Pipeline pipeline = new Pipeline(this.id, this.type, this.factor, this.state, this.nodeStatus);
            pipeline.setLeaderId(this.leaderId);
            if (this.creationTimestamp != null) {
                pipeline.setCreationTimestamp(this.creationTimestamp);
            }
            if (this.nodeOrder != null && !this.nodeOrder.isEmpty()) {
                ArrayList<DatanodeDetails> nodesWithOrder = new ArrayList<DatanodeDetails>();
                block0: for (int i = 0; i < this.nodeOrder.size(); ++i) {
                    Iterator<DatanodeDetails> it = this.nodeStatus.keySet().iterator();
                    for (int nodeIndex = this.nodeOrder.get(i).intValue(); it.hasNext() && nodeIndex >= 0; --nodeIndex) {
                        DatanodeDetails node = it.next();
                        if (nodeIndex != 0) continue;
                        nodesWithOrder.add(node);
                        continue block0;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deserialize nodesInOrder {} in pipeline {}", nodesWithOrder, (Object)this.id);
                }
                pipeline.setNodesInOrder(nodesWithOrder);
            } else if (this.nodesInOrder != null) {
                pipeline.setNodesInOrder(this.nodesInOrder);
            }
            return pipeline;
        }
    }
}

