/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.util.regex.Pattern;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.thirdparty.io.grpc.Context;
import org.apache.ratis.thirdparty.io.grpc.Metadata;

@InterfaceAudience.Private
public final class OzoneConsts {
    public static final String STORAGE_DIR = "scm";
    public static final String SCM_ID = "scmUuid";
    public static final String OZONE_SIMPLE_ROOT_USER = "root";
    public static final String OZONE_SIMPLE_HDFS_USER = "hdfs";
    public static final String STORAGE_ID = "storageID";
    public static final String DATANODE_UUID = "datanodeUuid";
    public static final String CLUSTER_ID = "clusterID";
    public static final String LAYOUTVERSION = "layOutVersion";
    public static final String CTIME = "ctime";
    public static final int OZONE_MIN_BUCKET_NAME_LENGTH = 3;
    public static final int OZONE_MAX_BUCKET_NAME_LENGTH = 63;
    public static final String OZONE_ACL_USER_TYPE = "user";
    public static final String OZONE_ACL_GROUP_TYPE = "group";
    public static final String OZONE_ACL_WORLD_TYPE = "world";
    public static final String OZONE_ACL_ANONYMOUS_TYPE = "anonymous";
    public static final String OZONE_ACL_IP_TYPE = "ip";
    public static final String OZONE_ACL_READ = "r";
    public static final String OZONE_ACL_WRITE = "w";
    public static final String OZONE_ACL_DELETE = "d";
    public static final String OZONE_ACL_LIST = "l";
    public static final String OZONE_ACL_ALL = "a";
    public static final String OZONE_ACL_NONE = "n";
    public static final String OZONE_ACL_CREATE = "c";
    public static final String OZONE_ACL_READ_ACL = "x";
    public static final String OZONE_ACL_WRITE_ACL = "y";
    public static final String OZONE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String OZONE_TIME_ZONE = "GMT";
    public static final String OZONE_COMPONENT = "component";
    public static final String OZONE_FUNCTION = "function";
    public static final String OZONE_RESOURCE = "resource";
    public static final String OZONE_USER = "user";
    public static final String OZONE_REQUEST = "request";
    public static final String OZONE_OM_SERVICE_LIST_HTTP_ENDPOINT = "/serviceList";
    public static final String OZONE_OM_DB_CHECKPOINT_HTTP_ENDPOINT = "/dbCheckpoint";
    public static final String OZONE_URI_SCHEME = "o3fs";
    public static final String OZONE_OFS_URI_SCHEME = "ofs";
    public static final String OZONE_RPC_SCHEME = "o3";
    public static final String OZONE_HTTP_SCHEME = "http";
    public static final String OZONE_URI_DELIMITER = "/";
    public static final String OZONE_ROOT = "/";
    public static final String CONTAINER_EXTENSION = ".container";
    public static final String CONTAINER_META = ".meta";
    public static final String CONTAINER_PREFIX = "containers";
    public static final String CONTAINER_META_PATH = "metadata";
    public static final String CONTAINER_TEMPORARY_CHUNK_PREFIX = "tmp";
    public static final String CONTAINER_CHUNK_NAME_DELIMITER = ".";
    public static final String CONTAINER_ROOT_PREFIX = "repository";
    public static final String FILE_HASH = "SHA-256";
    public static final String MD5_HASH = "MD5";
    public static final String CHUNK_OVERWRITE = "OverWriteRequested";
    public static final int CHUNK_SIZE = 0x100000;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final String CONTAINER_DB_SUFFIX = "container.db";
    public static final String PIPELINE_DB_SUFFIX = "pipeline.db";
    public static final String DN_CONTAINER_DB = "-dn-container.db";
    public static final String OM_DB_NAME = "om.db";
    public static final String OM_DB_BACKUP_PREFIX = "om.db.backup.";
    public static final String STORAGE_DIR_CHUNKS = "chunks";
    public static final String OZONE_DB_CHECKPOINT_REQUEST_FLUSH = "flushBeforeCheckpoint";
    public static final String DELETING_KEY_PREFIX = "#deleting#";
    public static final String DELETED_KEY_PREFIX = "#deleted#";
    public static final String DELETE_TRANSACTION_KEY_PREFIX = "#delTX#";
    public static final String BLOCK_COMMIT_SEQUENCE_ID_PREFIX = "#BCSID";
    public static final String BLOCK_COUNT = "#BLOCKCOUNT";
    public static final String CONTAINER_BYTES_USED = "#BYTESUSED";
    public static final String PENDING_DELETE_BLOCK_COUNT = "#PENDINGDELETEBLOCKCOUNT";
    public static final byte[] DB_BLOCK_COUNT_KEY = StringUtils.string2Bytes("#BLOCKCOUNT");
    public static final byte[] DB_CONTAINER_BYTES_USED_KEY = StringUtils.string2Bytes("#BYTESUSED");
    public static final byte[] DB_PENDING_DELETE_BLOCK_COUNT_KEY = StringUtils.string2Bytes("#PENDINGDELETEBLOCKCOUNT");
    public static final byte[] DB_CONTAINER_DELETE_TRANSACTION_KEY = StringUtils.string2Bytes("#delTX#");
    public static final byte[] DB_BLOCK_COMMIT_SEQUENCE_ID_KEY = StringUtils.string2Bytes("#BCSID");
    public static final String OM_KEY_PREFIX = "/";
    public static final String OM_USER_PREFIX = "$";
    public static final String OM_S3_PREFIX = "S3:";
    public static final String OM_S3_VOLUME_PREFIX = "s3";
    public static final String OM_S3_SECRET = "S3Secret:";
    public static final String OM_PREFIX = "Prefix:";
    public static final int OZONE_SCM_CHUNK_MAX_SIZE = 0x2000000;
    public static final long MAX_QUOTA_IN_BYTES = 0x1000000000000000L;
    public static final int MAX_LISTBUCKETS_SIZE = 1024;
    public static final int MAX_LISTKEYS_SIZE = 1024;
    public static final int MAX_LISTVOLUMES_SIZE = 1024;
    public static final int INVALID_PORT = -1;
    public static final String OZONE_SCM_DATANODE_ID_FILE_DEFAULT = "datanode.id";
    public static final String OM_CONTEXT_ATTRIBUTE = "ozone.om";
    public static final String CONTAINER_ID = "containerID";
    public static final String CONTAINER_TYPE = "containerType";
    public static final String STATE = "state";
    public static final String METADATA = "metadata";
    public static final String MAX_SIZE = "maxSize";
    public static final String METADATA_PATH = "metadataPath";
    public static final String CHUNKS_PATH = "chunksPath";
    public static final String CONTAINER_DB_TYPE = "containerDBType";
    public static final String CHECKSUM = "checksum";
    public static final String DATA_SCAN_TIMESTAMP = "dataScanTimestamp";
    public static final String ORIGIN_PIPELINE_ID = "originPipelineId";
    public static final String ORIGIN_NODE_ID = "originNodeId";
    public static final String OZONE = "ozone";
    public static final String S3 = "s3";
    public static final String VOLUME = "volume";
    public static final String BUCKET = "bucket";
    public static final String KEY = "key";
    public static final String SRC_KEY = "srcKey";
    public static final String DST_KEY = "dstKey";
    public static final String QUOTA_IN_BYTES = "quotaInBytes";
    public static final String OBJECT_ID = "objectID";
    public static final String UPDATE_ID = "updateID";
    public static final String CLIENT_ID = "clientID";
    public static final String OWNER = "owner";
    public static final String ADMIN = "admin";
    public static final String USERNAME = "username";
    public static final String PREV_KEY = "prevKey";
    public static final String START_KEY = "startKey";
    public static final String MAX_KEYS = "maxKeys";
    public static final String PREFIX = "prefix";
    public static final String KEY_PREFIX = "keyPrefix";
    public static final String ACL = "acl";
    public static final String ACLS = "acls";
    public static final String USER_ACL = "userAcl";
    public static final String ADD_ACLS = "addAcls";
    public static final String REMOVE_ACLS = "removeAcls";
    public static final String MAX_NUM_OF_BUCKETS = "maxNumOfBuckets";
    public static final String TO_KEY_NAME = "toKeyName";
    public static final String STORAGE_TYPE = "storageType";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final String IS_VERSION_ENABLED = "isVersionEnabled";
    public static final String CREATION_TIME = "creationTime";
    public static final String MODIFICATION_TIME = "modificationTime";
    public static final String DATA_SIZE = "dataSize";
    public static final String REPLICATION_TYPE = "replicationType";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String KEY_LOCATION_INFO = "keyLocationInfo";
    public static final String MULTIPART_LIST = "multipartList";
    public static final String UPLOAD_ID = "uploadID";
    public static final String PART_NUMBER_MARKER = "partNumberMarker";
    public static final String MAX_PARTS = "maxParts";
    public static final String S3_BUCKET = "s3Bucket";
    public static final String S3_GETSECRET_USER = "S3GetSecretUser";
    public static final String MULTIPART_UPLOAD_PART_NUMBER = "partNumber";
    public static final String MULTIPART_UPLOAD_PART_NAME = "partName";
    public static final String BUCKET_ENCRYPTION_KEY = "bucketEncryptionKey";
    public static final String DELETED_KEYS_LIST = "deletedKeysList";
    public static final String UNDELETED_KEYS_LIST = "unDeletedKeysList";
    public static final String SOURCE_VOLUME = "sourceVolume";
    public static final String SOURCE_BUCKET = "sourceBucket";
    public static final String OM_METRICS_FILE = "omMetrics";
    public static final String OM_METRICS_TEMP_FILE = "omMetrics.tmp";
    public static final int OM_MULTIPART_MIN_SIZE = 0x500000;
    public static final String OZONE_BLOCK_TOKEN = "blocktoken";
    public static final Context.Key<UserGroupInformation> UGI_CTX_KEY = Context.key((String)"UGI");
    public static final Metadata.Key<String> OBT_METADATA_KEY = Metadata.Key.of((String)"blocktoken", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> USER_METADATA_KEY = Metadata.Key.of((String)"user", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final String RPC_PORT = "RPC";
    public static final String OM_SERVICE_ID_DEFAULT = "omServiceIdDefault";
    public static final String OM_NODE_ID_DUMMY = "omNodeIdDummy";
    public static final String JAVA_TMP_DIR = "java.io.tmpdir";
    public static final String LOCALHOST = "localhost";
    public static final int S3_BUCKET_MIN_LENGTH = 3;
    public static final int S3_BUCKET_MAX_LENGTH = 64;
    public static final String GDPR_FLAG = "gdprEnabled";
    public static final String GDPR_ALGORITHM_NAME = "AES";
    public static final int GDPR_DEFAULT_RANDOM_SECRET_LENGTH = 16;
    public static final String GDPR_CHARSET = "UTF-8";
    public static final String GDPR_LENGTH = "length";
    public static final String GDPR_SECRET = "secret";
    public static final String GDPR_ALGORITHM = "algorithm";
    public static final Pattern KEYNAME_ILLEGAL_CHARACTER_CHECK_REGEX = Pattern.compile("^[^^{}<>^?%~#`\\[\\]\\|\\\\(\\x80-\\xff)]+$");
    public static final String FS_FILE_COPYING_TEMP_SUFFIX = "._COPYING_";
    public static final String TRANSACTION_INFO_KEY = "#TRANSACTIONINFO";
    public static final String TRANSACTION_INFO_SPLIT_KEY = "#";
    public static final String CONTAINER_DB_TYPE_ROCKSDB = "RocksDB";
    public static final String CONTAINER_DB_TYPE_LEVELDB = "LevelDB";
    public static final String DB_TRANSIENT_MARKER = "dbInconsistentMarker";

    private OzoneConsts() {
    }

    public static enum Versioning {
        NOT_DEFINED,
        ENABLED,
        DISABLED;


        public static Versioning getVersioning(boolean versioning) {
            return versioning ? ENABLED : DISABLED;
        }
    }
}

